/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.processor;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallProcessor;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallServerListStrategies;
import org.apache.camel.component.kubernetes.processor.KubernetesServiceCallServerListStrategy;
import org.apache.camel.impl.remote.DefaultServiceCallProcessor;
import org.apache.camel.impl.remote.DefaultServiceCallProcessorFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.ObjectHelper;

public class KubernetesProcessorFactory
extends DefaultServiceCallProcessorFactory<KubernetesConfiguration, ServiceCallServer> {
    protected KubernetesConfiguration createConfiguration(RouteContext routeContext) throws Exception {
        return new KubernetesConfiguration();
    }

    protected DefaultServiceCallProcessor createProcessor(String name, String component, String uri, ExchangePattern mep, KubernetesConfiguration conf, Map<String, String> properties) throws Exception {
        return new KubernetesServiceCallProcessor(name, component, uri, mep, conf);
    }

    protected Optional<ServiceCallServerListStrategy> builtInServerListStrategy(KubernetesConfiguration conf, String name) throws Exception {
        KubernetesServiceCallServerListStrategy strategy = null;
        if (ObjectHelper.equal((Object)"client", (Object)name, (boolean)true)) {
            strategy = new KubernetesServiceCallServerListStrategies.Client(conf);
        } else if (ObjectHelper.equal((Object)"environment", (Object)name, (boolean)true)) {
            strategy = new KubernetesServiceCallServerListStrategies.Environment(conf);
        } else if (ObjectHelper.equal((Object)"env", (Object)name, (boolean)true)) {
            strategy = new KubernetesServiceCallServerListStrategies.Environment(conf);
        } else if (ObjectHelper.equal((Object)"dns", (Object)name, (boolean)true)) {
            strategy = new KubernetesServiceCallServerListStrategies.DNS(conf);
        }
        return Optional.ofNullable(strategy);
    }

    protected ServiceCallServerListStrategy<ServiceCallServer> createDefaultServerListStrategy(KubernetesConfiguration conf) throws Exception {
        return new KubernetesServiceCallServerListStrategies.Client(conf);
    }
}

