/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.processor;

import org.apache.camel.Exchange;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDnsServiceCallExpression
extends ExpressionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesDnsServiceCallExpression.class);
    private final String name;
    private final String scheme;
    private final String contextPath;
    private final String uri;

    public KubernetesDnsServiceCallExpression(String name, String scheme, String contextPath, String uri) {
        this.name = name;
        this.scheme = scheme;
        this.contextPath = contextPath;
        this.uri = uri;
    }

    public Object evaluate(Exchange exchange) {
        try {
            return KubernetesDnsServiceCallExpression.buildCamelEndpointUri(this.name, this.uri, this.contextPath, this.scheme, (String)ObjectHelper.notNull((Object)exchange.getIn().getHeader("CamelServiceCallServerIp", String.class), (String)"CamelServiceCallServerIp"));
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected static String buildCamelEndpointUri(String name, String uri, String contextPath, String scheme, String dnsServicePart) {
        String answer = uri;
        if (answer == null) {
            if (scheme == null) {
                scheme = "http";
            }
            answer = scheme + "://" + dnsServicePart;
            if (contextPath != null) {
                answer = answer + "/" + contextPath;
            }
        } else if (answer.contains(name)) {
            answer = answer.replaceFirst(name, dnsServicePart);
        }
        LOG.debug("Camel endpoint uri: {} for calling service: {}", (Object)answer, (Object)name);
        return answer;
    }
}

