/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ribbon.processor;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.component.ribbon.RibbonConfiguration;
import org.apache.camel.component.ribbon.processor.RibbonServer;
import org.apache.camel.component.ribbon.processor.RibbonServiceCallStaticServerListStrategy;
import org.apache.camel.impl.remote.DefaultServiceCallExpression;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonServiceCallProcessor
extends ServiceSupport
implements AsyncProcessor,
CamelContextAware,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(RibbonServiceCallProcessor.class);
    private CamelContext camelContext;
    private String id;
    private final String name;
    private final String scheme;
    private final String contextPath;
    private final String uri;
    private final ExchangePattern exchangePattern;
    private final RibbonConfiguration configuration;
    private ServiceCallServerListStrategy<RibbonServer> serverListStrategy;
    private ZoneAwareLoadBalancer<RibbonServer> ribbonLoadBalancer;
    private IRule rule;
    private IPing ping;
    private final DefaultServiceCallExpression serviceCallExpression;
    private Map<String, String> ribbonClientConfig;
    private SendDynamicProcessor processor;

    public RibbonServiceCallProcessor(String name, String uri, String scheme, ExchangePattern exchangePattern, RibbonConfiguration configuration) {
        String serviceName;
        if (name.contains("/")) {
            serviceName = ObjectHelper.before((String)name, (String)"/");
            this.contextPath = ObjectHelper.after((String)name, (String)"/");
        } else if (name.contains("?")) {
            serviceName = ObjectHelper.before((String)name, (String)"?");
            this.contextPath = ObjectHelper.after((String)name, (String)"?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = ObjectHelper.before((String)serviceName, (String)":");
            this.name = ObjectHelper.after((String)serviceName, (String)":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        this.configuration = configuration;
        this.rule = configuration.getRule();
        this.ping = configuration.getPing();
        this.serviceCallExpression = new DefaultServiceCallExpression(this.name, this.scheme, this.contextPath, this.uri);
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Server server = null;
        try {
            server = this.ribbonLoadBalancer.chooseServer();
            if (server == null) {
                exchange.setException((Throwable)new RejectedExecutionException("No active services with name " + this.name));
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        if (exchange.getException() != null) {
            callback.done(true);
            return true;
        }
        String ip = server.getHost();
        int port = server.getPort();
        LOG.debug("Service {} active at server: {}:{}", new Object[]{this.name, ip, port});
        exchange.getIn().setHeader("CamelServiceCallServerIp", (Object)ip);
        exchange.getIn().setHeader("CamelServiceCallServerPort", (Object)port);
        exchange.getIn().setHeader("CamelServiceCallServiceName", (Object)this.name);
        return this.processor.process(exchange, callback);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        return "kubernetes";
    }

    public ServiceCallServerListStrategy getServerListStrategy() {
        return this.serverListStrategy;
    }

    public void setServerListStrategy(ServiceCallServerListStrategy serverListStrategy) {
        this.serverListStrategy = serverListStrategy;
    }

    public IRule getRule() {
        return this.rule;
    }

    public void setRule(IRule rule) {
        this.rule = rule;
    }

    public IPing getPing() {
        return this.ping;
    }

    public void setPing(IPing ping) {
        this.ping = ping;
    }

    public Map<String, String> getRibbonClientConfig() {
        return this.ribbonClientConfig;
    }

    public void setRibbonClientConfig(Map<String, String> ribbonClientConfig) {
        this.ribbonClientConfig = ribbonClientConfig;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notEmpty((String)this.name, (String)"name", (Object)((Object)this));
        if (this.serverListStrategy == null) {
            this.serverListStrategy = new RibbonServiceCallStaticServerListStrategy();
        }
        if (!(this.serverListStrategy instanceof ServerList)) {
            throw new IllegalArgumentException("ServerListStrategy must be instanceof com.netflix.loadbalancer.ServerList but is of type: " + this.serverListStrategy.getClass().getName());
        }
        if (this.rule == null) {
            this.rule = new RoundRobinRule();
        }
        if (this.ping == null) {
            this.ping = new DummyPing();
        }
        IClientConfig config = IClientConfig.Builder.newBuilder((String)this.name).build();
        if (this.ribbonClientConfig != null) {
            for (Map.Entry<String, String> entry : this.ribbonClientConfig.entrySet()) {
                IClientConfigKey key = IClientConfigKey.Keys.valueOf((String)entry.getKey());
                String value = entry.getValue();
                LOG.debug("RibbonClientConfig: {}={}", (Object)key.key(), (Object)value);
                config.set(key, (Object)entry.getValue());
            }
        }
        PollingServerListUpdater updater = new PollingServerListUpdater(config);
        this.ribbonLoadBalancer = new ZoneAwareLoadBalancer(config, this.rule, this.ping, (ServerList)this.serverListStrategy, null, (ServerListUpdater)updater);
        LOG.info("RibbonServiceCall with service name: {} is using load balancer: {} and server list: {}", new Object[]{this.name, this.ribbonLoadBalancer, this.serverListStrategy});
        this.processor = new SendDynamicProcessor(this.uri, (Expression)this.serviceCallExpression);
        this.processor.setCamelContext(this.getCamelContext());
        if (this.exchangePattern != null) {
            this.processor.setPattern(this.exchangePattern);
        }
        ServiceHelper.startServices((Object[])new Object[]{this.serverListStrategy, this.processor});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.processor, this.serverListStrategy});
    }
}

