/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.auth;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.auth.OAuthToken;

@Provider
@Priority(value=1000)
public class AuthenticationRequestFilter
implements ClientRequestFilter {
    private final ServiceNowConfiguration configuration;
    private final OAuthToken token;
    private final String authString;

    public AuthenticationRequestFilter(ServiceNowConfiguration configuration) throws IOException {
        this.configuration = configuration;
        this.token = configuration.hasOAuthAuthentication() ? new OAuthToken(this.configuration) : null;
        this.authString = AuthenticationRequestFilter.buildBasicAuthString(configuration);
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.token != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.token.getAuthString());
        } else if (this.authString != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.authString);
        }
    }

    private static String buildBasicAuthString(ServiceNowConfiguration configuration) throws IOException {
        if (!configuration.hasBasicAuthentication()) {
            return null;
        }
        String userAndPassword = configuration.getUserName() + ":" + configuration.getPassword();
        return "Basic " + DatatypeConverter.printBase64Binary((byte[])userAndPassword.getBytes("UTF-8"));
    }
}

