/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;

@Provider
@Priority(value=5000)
public class ServiceNowExceptionMapper
implements ResponseExceptionMapper<ServiceNowException> {
    private final ObjectMapper mapper;

    public ServiceNowExceptionMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public ServiceNowException fromResponse(Response r) {
        int code = r.getStatus();
        try {
            switch (code) {
                case 200: 
                case 201: 
                case 204: {
                    break;
                }
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 415: {
                    return (ServiceNowException)((Object)this.mapper.readValue((InputStream)r.readEntity(InputStream.class), ServiceNowException.class));
                }
            }
        }
        catch (IOException e) {
            return new ServiceNowException(e);
        }
        return null;
    }
}

