/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonObject;
import org.apache.camel.Exchange;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbConsumer;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.lightcouch.Changes;
import org.lightcouch.ChangesResult;
import org.lightcouch.CouchDbInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbChangesetTracker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbChangesetTracker.class);
    private volatile boolean stopped;
    private final CouchDbClientWrapper couchClient;
    private final CouchDbEndpoint endpoint;
    private final CouchDbConsumer consumer;
    private Changes changes;

    public CouchDbChangesetTracker(CouchDbEndpoint endpoint, CouchDbConsumer consumer, CouchDbClientWrapper couchClient) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.couchClient = couchClient;
        this.initChanges();
    }

    void initChanges() {
        CouchDbInfo dbInfo = this.couchClient.context().info();
        String since = dbInfo.getUpdateSeq();
        LOG.debug("Last sequence [{}]", (Object)since);
        this.changes = this.couchClient.changes().style(this.endpoint.getStyle()).includeDocs(true).since(since).heartBeat(this.endpoint.getHeartbeat()).continuousChanges();
    }

    @Override
    public void run() {
        while (this.changes.hasNext()) {
            ChangesResult.Row feed = this.changes.next();
            if (feed.isDeleted() && !this.endpoint.isDeletes() || !feed.isDeleted() && !this.endpoint.isUpdates()) continue;
            String seq = feed.getSeq();
            JsonObject doc = feed.getDoc();
            Exchange exchange = this.endpoint.createExchange(seq, feed.getId(), doc, feed.isDeleted());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created exchange [exchange={}, _id={}, seq={}", new Object[]{exchange, feed.getId(), seq});
            }
            try {
                this.consumer.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.consumer.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)e);
            }
        }
        this.stopped = true;
    }

    public void stop() {
        this.changes.stop();
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

