/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack.io;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.Inflater;
import org.apache.camel.component.lumberjack.io.LumberjackMessage;
import org.apache.camel.component.lumberjack.io.LumberjackSessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LumberjackFrameDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(LumberjackFrameDecoder.class);
    private final LumberjackSessionHandler sessionHandler;
    private final Gson gson;

    LumberjackFrameDecoder(LumberjackSessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
        this.gson = new Gson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        boolean frameDecoded = false;
        try {
            if (!in.isReadable(2)) {
                return;
            }
            short frameVersion = in.readUnsignedByte();
            this.sessionHandler.versionRead(frameVersion);
            short frameType = in.readUnsignedByte();
            LOG.debug("Received a lumberjack frame of type {}", (Object)Character.valueOf((char)frameType));
            switch (frameType) {
                case 74: {
                    frameDecoded = this.handleJsonFrame(in, out);
                    return;
                }
                case 68: {
                    frameDecoded = this.handleDataFrame(in, out);
                    return;
                }
                case 87: {
                    frameDecoded = this.handleWindowFrame(in);
                    return;
                }
                case 67: {
                    frameDecoded = this.handleCompressedFrame(ctx, in, out);
                    return;
                }
                default: {
                    throw new RuntimeException("Unsupported frame type=" + frameType);
                }
            }
        }
        finally {
            if (!frameDecoded) {
                LOG.debug("Not enough data to decode a complete frame, retry when more data is available. Reader index was {}", (Object)in.readerIndex());
                in.resetReaderIndex();
            }
        }
    }

    private boolean handleJsonFrame(ByteBuf in, List<Object> out) {
        if (!in.isReadable(8)) {
            return false;
        }
        int sequenceNumber = in.readInt();
        String jsonStr = this.readLengthPrefixedString(in);
        if (jsonStr == null) {
            return false;
        }
        Object jsonMessage = this.gson.fromJson(jsonStr, Object.class);
        out.add(new LumberjackMessage(sequenceNumber, jsonMessage));
        return true;
    }

    private boolean handleDataFrame(ByteBuf in, List<Object> out) {
        if (!in.isReadable(8)) {
            return false;
        }
        int sequenceNumber = in.readInt();
        int entriesCount = in.readInt();
        LinkedHashMap<String, String> dataMessage = new LinkedHashMap<String, String>();
        while (entriesCount-- > 0) {
            String key = this.readLengthPrefixedString(in);
            if (key == null) {
                return false;
            }
            String value = this.readLengthPrefixedString(in);
            if (value == null) {
                return false;
            }
            dataMessage.put(key, value);
        }
        out.add(new LumberjackMessage(sequenceNumber, dataMessage));
        return true;
    }

    private boolean handleWindowFrame(ByteBuf in) {
        if (!in.isReadable(4)) {
            return false;
        }
        this.sessionHandler.windowSizeRead(in.readInt());
        return true;
    }

    private boolean handleCompressedFrame(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!in.isReadable(4)) {
            return false;
        }
        int compressedPayloadLength = in.readInt();
        if (!in.isReadable(compressedPayloadLength)) {
            return false;
        }
        Inflater inflater = new Inflater();
        if (in.hasArray()) {
            inflater.setInput(in.array(), in.arrayOffset() + in.readerIndex(), compressedPayloadLength);
            in.skipBytes(compressedPayloadLength);
        } else {
            byte[] array = new byte[compressedPayloadLength];
            in.readBytes(array);
            inflater.setInput(array);
        }
        while (!inflater.finished()) {
            ByteBuf decompressed = ctx.alloc().heapBuffer(1024, 1024);
            byte[] outArray = decompressed.array();
            int count = inflater.inflate(outArray, decompressed.arrayOffset(), decompressed.writableBytes());
            decompressed.writerIndex(count);
            out.add(decompressed);
        }
        return true;
    }

    private String readLengthPrefixedString(ByteBuf in) {
        if (!in.isReadable(4)) {
            return null;
        }
        int length = in.readInt();
        if (!in.isReadable(length)) {
            return null;
        }
        String str = in.toString(in.readerIndex(), length, StandardCharsets.UTF_8);
        in.skipBytes(length);
        return str;
    }
}

