/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lumberjack;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.lumberjack.LumberjackEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.jsse.SSLContextParameters;

public class LumberjackComponent
extends UriEndpointComponent {
    static final int DEFAULT_PORT = 5044;
    private SSLContextParameters sslContextParameters;

    public LumberjackComponent() {
        this(LumberjackEndpoint.class);
    }

    protected LumberjackComponent(Class<? extends LumberjackEndpoint> endpointClass) {
        super(endpointClass);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int port;
        String host;
        int separatorIndex = remaining.indexOf(58);
        if (separatorIndex >= 0) {
            host = remaining.substring(0, separatorIndex);
            port = Integer.parseInt(remaining.substring(separatorIndex + 1));
        } else {
            host = remaining;
            port = 5044;
        }
        LumberjackEndpoint answer = new LumberjackEndpoint(uri, this, host, port);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

