/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.LoadPropertiesException;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelContextHelper {
    public static final String COMPONENT_BASE = "META-INF/services/org/apache/camel/component/";
    public static final String COMPONENT_DESCRIPTOR = "META-INF/services/org/apache/camel/component.properties";
    public static final String COMPONENT_DOCUMENTATION_PREFIX = "org/apache/camel/component/";
    public static final String MODEL_DESCRIPTOR = "META-INF/services/org/apache/camel/model.properties";
    public static final String MODEL_DOCUMENTATION_PREFIX = "org/apache/camel/model/";
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextHelper.class);

    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, endpoint));
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull(context, "camelContext");
        return context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookupByName(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return context.getRegistry().lookupByNameAndType(name, beanType);
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        if (answer == null) {
            throw new NoSuchBeanException(name);
        }
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        if (answer == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return answer;
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String ref, String injectionPointName, boolean mandatory) {
        Endpoint endpoint;
        if (ObjectHelper.isNotEmpty(uri) && ObjectHelper.isNotEmpty(ref)) {
            throw new IllegalArgumentException("Both uri and name is provided, only either one is allowed: uri=" + uri + ", ref=" + ref);
        }
        if (ObjectHelper.isNotEmpty(uri)) {
            endpoint = camelContext.getEndpoint(uri);
        } else if (ObjectHelper.isNotEmpty(ref)) {
            endpoint = CamelContextHelper.mandatoryLookup(camelContext, ref, Endpoint.class);
        } else {
            if (ObjectHelper.isEmpty(ref)) {
                ref = injectionPointName;
            }
            endpoint = mandatory ? CamelContextHelper.mandatoryLookup(camelContext, ref, Endpoint.class) : CamelContextHelper.lookup(camelContext, ref, Endpoint.class);
        }
        return endpoint;
    }

    public static int getMaximumCachePoolSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getProperty("CamelMaximumCachePoolSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumEndpointCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getProperty("CamelMaximumEndpointCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static String parseText(CamelContext camelContext, String text) throws Exception {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    public static Integer parseInteger(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Long parseLong(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Long.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a Long.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Long.", e);
            }
        }
        return null;
    }

    public static Double parseDouble(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return camelContext.getTypeConverter().mandatoryConvertTo(Double.class, s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Boolean parseBoolean(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("true") || s.equals("false")) {
                return "true".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (s.equals(text)) {
                throw new IllegalArgumentException("Error parsing [" + s + "] as a Boolean.");
            }
            throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Boolean.");
        }
        return null;
    }

    public static SortedMap<String, Properties> findComponents(CamelContext camelContext) throws LoadPropertiesException {
        ClassResolver resolver = camelContext.getClassResolver();
        LOG.debug("Finding all components using class resolver: {} -> {}", new Object[]{resolver});
        Enumeration<URL> iter = resolver.loadAllResourcesAsURL(COMPONENT_DESCRIPTOR);
        return CamelContextHelper.findComponents(camelContext, iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, Properties> findComponents(CamelContext camelContext, Enumeration<URL> componentDescriptionIter) throws LoadPropertiesException {
        TreeMap<String, Properties> map = new TreeMap<String, Properties>();
        while (componentDescriptionIter != null && componentDescriptionIter.hasMoreElements()) {
            URL url = componentDescriptionIter.nextElement();
            LOG.trace("Finding components in url: {}", (Object)url);
            try {
                Properties properties = new Properties();
                properties.load(url.openStream());
                String names = properties.getProperty("components");
                if (names == null) continue;
                StringTokenizer tok = new StringTokenizer(names);
                while (tok.hasMoreTokens()) {
                    String name = tok.nextToken();
                    String className = null;
                    InputStream is = null;
                    try {
                        Enumeration<URL> urls = camelContext.getClassResolver().loadAllResourcesAsURL(COMPONENT_BASE + name);
                        if (urls != null && urls.hasMoreElements()) {
                            is = urls.nextElement().openStream();
                        }
                        if (is != null) {
                            Properties compProperties = new Properties();
                            compProperties.load(is);
                            if (!compProperties.isEmpty()) {
                                className = compProperties.getProperty("class");
                            }
                        }
                    }
                    catch (Exception urls) {
                    }
                    finally {
                        IOHelper.close(is);
                    }
                    Properties prop = new Properties();
                    prop.putAll((Map<?, ?>)properties);
                    if (camelContext.hasComponent(name) != null) {
                        prop.put("component", camelContext.getComponent(name));
                    }
                    if (className != null) {
                        prop.put("class", className);
                    }
                    prop.put("name", name);
                    map.put(name, prop);
                }
            }
            catch (IOException e) {
                throw new LoadPropertiesException(url, e);
            }
        }
        List<String> names = camelContext.getComponentNames();
        for (String name : names) {
            Component component;
            if (map.containsKey(name) || (component = camelContext.getComponent(name)) == null) continue;
            Properties properties = new Properties();
            properties.put("component", component);
            properties.put("class", component.getClass().getName());
            properties.put("name", name);
            map.put(name, properties);
        }
        Map<String, Component> beanMap = camelContext.getRegistry().findByTypeWithName(Component.class);
        Set<Map.Entry<String, Component>> entries = beanMap.entrySet();
        for (Map.Entry<String, Component> entry : entries) {
            Component component;
            String name = entry.getKey();
            if (map.containsKey(name) || (component = entry.getValue()) == null) continue;
            Properties properties = new Properties();
            properties.put("component", component);
            properties.put("class", component.getClass().getName());
            properties.put("name", name);
            map.put(name, properties);
        }
        return map;
    }

    public static SortedMap<String, Properties> findEips(CamelContext camelContext) throws LoadPropertiesException {
        TreeMap<String, Properties> answer = new TreeMap<String, Properties>();
        ClassResolver resolver = camelContext.getClassResolver();
        LOG.debug("Finding all EIPs using class resolver: {} -> {}", new Object[]{resolver});
        URL url = resolver.loadResourceAsURL(MODEL_DESCRIPTOR);
        if (url != null) {
            InputStream is = null;
            try {
                String[] lines;
                is = url.openStream();
                String all = IOHelper.loadText(is);
                for (String line : lines = all.split("\n")) {
                    if (line.startsWith("#")) continue;
                    Properties prop = new Properties();
                    prop.put("name", line);
                    String description = null;
                    String label = null;
                    String javaType = null;
                    String title = null;
                    String json = camelContext.explainEipJson(line, false);
                    if (json != null) {
                        List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("model", json, false);
                        for (Map<String, String> row : rows) {
                            if (row.get("title") != null) {
                                title = row.get("title");
                            }
                            if (row.get("description") != null) {
                                description = row.get("description");
                            }
                            if (row.get("label") != null) {
                                label = row.get("label");
                            }
                            if (row.get("javaType") == null) continue;
                            javaType = row.get("javaType");
                        }
                    }
                    if (title != null) {
                        prop.put("title", title);
                    }
                    if (description != null) {
                        prop.put("description", description);
                    }
                    if (label != null) {
                        prop.put("label", label);
                    }
                    if (javaType != null) {
                        prop.put("class", javaType);
                    }
                    answer.put(line, prop);
                }
            }
            catch (IOException e) {
                throw new LoadPropertiesException(url, e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return answer;
    }

    public static int getRouteStartupOrder(CamelContext camelContext, String routeId) {
        for (RouteStartupOrder order : camelContext.getRouteStartupOrder()) {
            if (!order.getRoute().getId().equals(routeId)) continue;
            return order.getStartupOrder();
        }
        return 0;
    }

    public static Component lookupPropertiesComponent(CamelContext camelContext, boolean autoCreate) {
        Object found;
        PropertiesComponent answer = (PropertiesComponent)camelContext.hasComponent("properties");
        if (answer == null && (found = camelContext.getRegistry().lookupByName("properties")) != null && found instanceof PropertiesComponent) {
            answer = (PropertiesComponent)found;
            camelContext.addComponent("properties", answer);
        }
        if (answer == null && autoCreate) {
            LOG.info("No existing PropertiesComponent has been configured, creating a new default PropertiesComponent with name: properties");
            answer = new PropertiesComponent(true);
            camelContext.addComponent("properties", answer);
        }
        return answer;
    }

    public static boolean isEipInUse(CamelContext camelContext, String name) {
        for (RouteDefinition route : camelContext.getRouteDefinitions()) {
            for (FromDefinition from : route.getInputs()) {
                if (!name.equals(from.getShortName())) continue;
                return true;
            }
            Iterator<ProcessorDefinition> it = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
            while (it.hasNext()) {
                ProcessorDefinition def = it.next();
                if (!name.equals(def.getShortName())) continue;
                return true;
            }
        }
        return false;
    }
}

