/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation")
@XmlType(name="dataFormat")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatDefinition
extends IdentifiedType
implements OtherAttributesAware {
    @XmlTransient
    private DataFormat dataFormat;
    @XmlTransient
    private String dataFormatName;
    @XmlAnyAttribute
    private Map<QName, Object> otherAttributes;

    public DataFormatDefinition() {
    }

    public DataFormatDefinition(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    protected DataFormatDefinition(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public static DataFormat getDataFormat(RouteContext routeContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull(ref, "ref or type");
            type = routeContext.getCamelContext().resolveDataFormatDefinition(ref);
            if (type != null) {
                return type.getDataFormat(routeContext);
            }
            DataFormat dataFormat = routeContext.getCamelContext().resolveDataFormat(ref);
            if (dataFormat == null) {
                throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
            }
            return dataFormat;
        }
        return type.getDataFormat(routeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFormat getDataFormat(RouteContext routeContext) {
        block7: {
            if (this.dataFormat == null) {
                Runnable propertyPlaceholdersChangeReverter = ProcessorDefinitionHelper.createPropertyPlaceholdersChangeReverter();
                try {
                    ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), (Object)this);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error resolving property placeholders on data format: " + this, e);
                }
                try {
                    this.dataFormat = this.createDataFormat(routeContext);
                    if (this.dataFormat != null) {
                        this.configureDataFormat(this.dataFormat, routeContext.getCamelContext());
                        break block7;
                    }
                    throw new IllegalArgumentException("Data format '" + (this.dataFormatName != null ? this.dataFormatName : "<null>") + "' could not be created. Ensure that the data format is valid and the associated Camel component is present on the classpath");
                }
                finally {
                    propertyPlaceholdersChangeReverter.run();
                }
            }
        }
        return this.dataFormat;
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.getDataFormatName() != null) {
            return routeContext.getCamelContext().resolveDataFormat(this.getDataFormatName());
        }
        return null;
    }

    @Deprecated
    protected void configureDataFormat(DataFormat dataFormat) {
    }

    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
    }

    @Deprecated
    protected void setProperty(Object bean, String name, Object value) {
        this.setProperty(null, bean, name, value);
    }

    protected void setProperty(CamelContext camelContext, Object bean, String name, Object value) {
        try {
            String ref;
            String string = ref = value instanceof String ? value.toString() : null;
            if (EndpointHelper.isReferenceParameter(ref) && camelContext != null) {
                IntrospectionSupport.setProperty(camelContext, camelContext.getTypeConverter(), bean, name, null, ref, true);
            } else {
                IntrospectionSupport.setProperty(bean, name, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property: " + name + " on: " + bean + ". Reason: " + e, e);
        }
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public void setDataFormatName(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String getShortName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("DataFormat")) {
            name = name.substring(0, name.indexOf("DataFormat"));
        }
        return name;
    }
}

