/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.remote;

import org.apache.camel.Exchange;
import org.apache.camel.support.ServiceCallExpressionSupport;
import org.apache.camel.util.ExchangeHelper;

public class DefaultServiceCallExpression
extends ServiceCallExpressionSupport {
    private final String ipHeader;
    private final String portHeader;

    public DefaultServiceCallExpression(String name, String scheme, String contextPath, String uri) {
        this(name, scheme, contextPath, uri, "CamelServiceCallServerIp", "CamelServiceCallServerPort");
    }

    public DefaultServiceCallExpression(String name, String scheme, String contextPath, String uri, String ipHeader, String portHeader) {
        super(name, scheme, contextPath, uri);
        this.ipHeader = ipHeader;
        this.portHeader = portHeader;
    }

    @Override
    public String getIp(Exchange exchange) throws Exception {
        return ExchangeHelper.getMandatoryHeader(exchange, this.ipHeader, String.class);
    }

    @Override
    public int getPort(Exchange exchange) throws Exception {
        return ExchangeHelper.getMandatoryHeader(exchange, this.portHeader, Integer.TYPE);
    }
}

