/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.ServiceCallServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.ObjectHelper;

public class CachingServiceCallServiceListStrategy<T extends ServiceCallServer>
implements ServiceCallServerListStrategy<T> {
    private final ServiceCallServerListStrategy<T> delegate;
    private List<T> servers;
    private long lastUpdate;
    private long timeout;

    public CachingServiceCallServiceListStrategy(ServiceCallServerListStrategy<T> delegate) {
        this.delegate = ObjectHelper.notNull(delegate, "delegate");
        this.lastUpdate = 0L;
        this.servers = Collections.emptyList();
        this.timeout = 60000L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CachingServiceCallServiceListStrategy<T> timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public CachingServiceCallServiceListStrategy<T> timeout(long timeout, TimeUnit unit) {
        this.setTimeout(timeout, unit);
        return this;
    }

    @Override
    public List<T> getInitialListOfServers(String name) {
        return this.delegate.getInitialListOfServers(name);
    }

    @Override
    public List<T> getUpdatedListOfServers(String name) {
        long now = System.currentTimeMillis();
        if (this.lastUpdate == 0L || now > this.lastUpdate + this.timeout) {
            List<T> updatedList = this.delegate.getUpdatedListOfServers(name);
            this.servers = updatedList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(updatedList));
            this.lastUpdate = now;
        }
        return this.servers;
    }

    public static <S extends ServiceCallServer> CachingServiceCallServiceListStrategy<S> wrap(ServiceCallServerListStrategy<S> delegate) {
        return new CachingServiceCallServiceListStrategy<S>(delegate);
    }

    public static <S extends ServiceCallServer> CachingServiceCallServiceListStrategy<S> wrap(ServiceCallServerListStrategy<S> delegate, long timeout) {
        return new CachingServiceCallServiceListStrategy<S>(delegate).timeout(timeout);
    }

    public static <S extends ServiceCallServer> CachingServiceCallServiceListStrategy<S> wrap(ServiceCallServerListStrategy<S> delegate, long timeout, TimeUnit unit) {
        return new CachingServiceCallServiceListStrategy<S>(delegate).timeout(timeout, unit);
    }
}

