/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.component.rest.RestProducerBindingProcessor;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;

public class RestProducer
extends DefaultAsyncProducer {
    private final CamelContext camelContext;
    private final RestConfiguration configuration;
    private boolean prepareUriTemplate = true;
    private String bindingMode;
    private Boolean skipBindingOnErrorCode;
    private String type;
    private String outType;
    private AsyncProcessor producer;
    private AsyncProcessor binding;

    public RestProducer(Endpoint endpoint, Producer producer, RestConfiguration configuration) {
        super(endpoint);
        this.camelContext = endpoint.getCamelContext();
        this.configuration = configuration;
        this.producer = AsyncProcessorConverterHelper.convert(producer);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.prepareExchange(exchange);
            if (this.binding != null) {
                return this.binding.process(exchange, callback);
            }
            return this.producer.process(exchange, callback);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    @Override
    public RestEndpoint getEndpoint() {
        return (RestEndpoint)super.getEndpoint();
    }

    public boolean isPrepareUriTemplate() {
        return this.prepareUriTemplate;
    }

    public void setPrepareUriTemplate(boolean prepareUriTemplate) {
        this.prepareUriTemplate = prepareUriTemplate;
    }

    public String getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(String bindingMode) {
        this.bindingMode = bindingMode;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareExchange(Exchange exchange) throws Exception {
        String query;
        String value;
        String key;
        String resolvedUriTemplate;
        boolean hasPath = false;
        String string = resolvedUriTemplate = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getUriTemplate() : this.getEndpoint().getPath();
        if (this.prepareUriTemplate && resolvedUriTemplate.contains("{")) {
            String[] arr = resolvedUriTemplate.split("\\/");
            CollectionStringBuffer csb = new CollectionStringBuffer("/");
            for (String a : arr) {
                if (a.startsWith("{") && a.endsWith("}")) {
                    key = a.substring(1, a.length() - 1);
                    value = exchange.getIn().getHeader(key, String.class);
                    if (value != null) {
                        hasPath = true;
                        csb.append(value);
                        continue;
                    }
                    csb.append(a);
                    continue;
                }
                csb.append(a);
            }
            resolvedUriTemplate = csb.toString();
        }
        if ((query = this.getEndpoint().getQueryParameters()) != null) {
            Map<String, Object> params = URISupport.parseQuery(query);
            for (Map.Entry entry : params.entrySet()) {
                String a;
                Object v = entry.getValue();
                if (v == null) continue;
                a = v.toString();
                if ((a = URLDecoder.decode(a, "UTF-8")).startsWith("{") && a.endsWith("}")) {
                    key = a.substring(1, a.length() - 1);
                    value = exchange.getIn().getHeader(key, String.class);
                    if (value != null) {
                        params.put(key, value);
                        continue;
                    }
                    params.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                params.put((String)entry.getKey(), entry.getValue());
            }
            query = URISupport.createQueryString(params);
        }
        if (query != null) {
            exchange.getIn().setHeader("CamelRestHttpQuery", query);
        }
        if (hasPath) {
            void var7_11;
            String host = this.getEndpoint().getHost();
            String basePath = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getPath() : null;
            basePath = FileUtil.stripLeadingSeparator(basePath);
            resolvedUriTemplate = FileUtil.stripLeadingSeparator(resolvedUriTemplate);
            if (basePath != null) {
                String string2 = String.format("%s/%s/%s", host, basePath, resolvedUriTemplate);
            } else {
                String string3 = String.format("%s/%s", host, resolvedUriTemplate);
            }
            exchange.getIn().setHeader("CamelRestHttpUri", var7_11);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.binding = this.createBindingProcessor();
        ServiceHelper.startServices(this.binding, this.producer);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopServices(this.producer, this.binding);
    }

    protected AsyncProcessor createBindingProcessor() throws Exception {
        String mode = this.configuration.getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode;
        }
        boolean skip = this.configuration.isSkipBindingOnErrorCode();
        if (this.skipBindingOnErrorCode != null) {
            skip = this.skipBindingOnErrorCode;
        }
        if (mode == null || "off".equals(mode)) {
            return null;
        }
        String name = this.configuration.getJsonDataFormat();
        if (name != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "json-jackson";
        }
        DataFormat json = this.camelContext.resolveDataFormat(name);
        DataFormat outJson = this.camelContext.resolveDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSon DataFormat " + name + " not found.");
        }
        if (json != null) {
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), json, "unmarshalType", clazz);
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), json, "useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, json, "json.in.");
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), outJson, "unmarshalType", outClazz);
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), outJson, "useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, outJson, "json.out.");
        }
        if ((name = this.configuration.getXmlDataFormat()) != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "jaxb";
        }
        DataFormat jaxb = this.camelContext.resolveDataFormat(name);
        DataFormat outJaxb = this.camelContext.resolveDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            JAXBContext jc;
            Class<?> clazz = null;
            if (this.type != null) {
                String typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (clazz != null) {
                JAXBContext jc2 = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), jaxb, "context", jc2);
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, jaxb, "xml.in.");
            Class<?> outClazz = null;
            if (this.outType != null) {
                String typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
            }
            if (outClazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{outClazz});
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), outJaxb, "context", jc);
            } else if (clazz != null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                IntrospectionSupport.setProperty(this.camelContext.getTypeConverter(), outJaxb, "context", jc);
            }
            this.setAdditionalConfiguration(this.configuration, this.camelContext, outJaxb, "xml.out.");
        }
        return new RestProducerBindingProcessor(this.producer, this.camelContext, json, jaxb, outJson, outJaxb, mode, skip, this.type, this.outType);
    }

    private void setAdditionalConfiguration(RestConfiguration config, CamelContext context, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : config.getDataFormatProperties().entrySet()) {
                String key = entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            EndpointHelper.setReferenceProperties(context, dataFormat, copy);
            EndpointHelper.setProperties(context, dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

