/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.component.sql.stored.CallableStatementWrapperFactory;
import org.apache.camel.component.sql.stored.SqlStoredComponent;
import org.apache.camel.component.sql.stored.SqlStoredProducer;
import org.apache.camel.component.sql.stored.template.TemplateParser;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.springframework.jdbc.core.JdbcTemplate;

@UriEndpoint(scheme="sql-stored", title="SQL StoredProcedure", syntax="sql-stored:template", producerOnly=true, label="database,sql")
public class SqlStoredEndpoint
extends DefaultPollingEndpoint {
    private CallableStatementWrapperFactory wrapperFactory;
    private JdbcTemplate jdbcTemplate;
    @UriParam(description="Sets the DataSource to use to communicate with the database.")
    private DataSource dataSource;
    @UriPath(description="Sets the StoredProcedure template to perform")
    @Metadata(required="true")
    private String template;
    @UriParam(description="Enables or disables batch mode")
    private boolean batch;
    @UriParam(description="Whether to use the message body as the template and then headers for parameters. If this option is enabled then the template in the uri is not used.")
    private boolean useMessageBodyForTemplate;
    @UriParam(description="If set, will ignore the results of the template and use the existing IN message as the OUT message for the continuation of processing")
    private boolean noop;
    @UriParam(description="Store the template result in a header instead of the message body. By default, outputHeader == null and the template result is stored in the message body, any existing content in the message body is discarded. If outputHeader is set, the value is used as the name of the header to store the template result and the original message body is preserved.")
    private String outputHeader;
    @UriParam(description="Whether this call is for a function.")
    private boolean function;

    public SqlStoredEndpoint(String uri, SqlStoredComponent component, JdbcTemplate jdbcTemplate) {
        super(uri, (Component)component);
        this.setJdbcTemplate(jdbcTemplate);
    }

    public Producer createProducer() throws Exception {
        return new SqlStoredProducer(this);
    }

    protected String createEndpointUri() {
        return "sql-stored:" + UnsafeUriCharactersEncoder.encode((String)this.template);
    }

    protected void doStart() throws Exception {
        this.wrapperFactory = new CallableStatementWrapperFactory(this.jdbcTemplate, new TemplateParser(), this.isFunction());
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.wrapperFactory != null) {
            this.wrapperFactory.shutdown();
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public boolean isUseMessageBodyForTemplate() {
        return this.useMessageBodyForTemplate;
    }

    public void setUseMessageBodyForTemplate(boolean useMessageBodyForTemplate) {
        this.useMessageBodyForTemplate = useMessageBodyForTemplate;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public String getOutputHeader() {
        return this.outputHeader;
    }

    public void setOutputHeader(String outputHeader) {
        this.outputHeader = outputHeader;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public boolean isSingleton() {
        return false;
    }

    public CallableStatementWrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }
}

