/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.support.RestConsumerContextPathMatcher;

public class UndertowConsumerResolver {
    public UndertowConsumer resolve(HttpServerExchange exchange, Map<String, UndertowConsumer> consumers) {
        UndertowConsumer answer = null;
        String path = exchange.getRequestPath();
        if (path == null) {
            return null;
        }
        HttpString method = exchange.getRequestMethod();
        if (method == null) {
            return null;
        }
        ArrayList<1> paths = new ArrayList<1>();
        for (final Map.Entry<String, UndertowConsumer> entry : consumers.entrySet()) {
            paths.add(new RestConsumerContextPathMatcher.ConsumerPath<UndertowConsumer>(){

                public String getRestrictMethod() {
                    return ((UndertowConsumer)((Object)entry.getValue())).getEndpoint().getHttpMethodRestrict();
                }

                public String getConsumerPath() {
                    return ((UndertowConsumer)((Object)entry.getValue())).getEndpoint().getHttpURI().getPath();
                }

                public UndertowConsumer getConsumer() {
                    return (UndertowConsumer)((Object)entry.getValue());
                }
            });
        }
        RestConsumerContextPathMatcher.ConsumerPath best = RestConsumerContextPathMatcher.matchBestPath((String)method.toString(), (String)path, paths);
        if (best != null) {
            answer = (UndertowConsumer)((Object)best.getConsumer());
        }
        if (answer == null) {
            for (String key : consumers.keySet()) {
                UndertowConsumer consumer;
                boolean matchOnUriPrefix;
                String consumerPath = consumers.get(key).getEndpoint().getHttpURI().getPath();
                if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = (consumer = consumers.get(key)).getEndpoint().getMatchOnUriPrefix().booleanValue()))) continue;
                answer = consumers.get(key);
                break;
            }
        }
        return answer;
    }
}

