/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dropbox.DropboxComponent;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollConsumer;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollGetConsumer;
import org.apache.camel.component.dropbox.integration.consumer.DropboxScheduledPollSearchConsumer;
import org.apache.camel.component.dropbox.integration.producer.DropboxDelProducer;
import org.apache.camel.component.dropbox.integration.producer.DropboxGetProducer;
import org.apache.camel.component.dropbox.integration.producer.DropboxMoveProducer;
import org.apache.camel.component.dropbox.integration.producer.DropboxPutProducer;
import org.apache.camel.component.dropbox.integration.producer.DropboxSearchProducer;
import org.apache.camel.component.dropbox.util.DropboxException;
import org.apache.camel.component.dropbox.util.DropboxOperation;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="dropbox", title="Dropbox", syntax="dropbox:operation", consumerClass=DropboxScheduledPollConsumer.class, label="api,file")
public class DropboxEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxEndpoint.class);
    @UriParam
    private DropboxConfiguration configuration;

    public DropboxEndpoint() {
    }

    public DropboxEndpoint(String uri, DropboxComponent component, DropboxConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public DropboxEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        LOG.trace("Resolve producer dropbox endpoint {" + this.configuration.getOperation().toString() + "}");
        LOG.trace("Resolve producer dropbox attached client: " + this.configuration.getClient());
        if (this.configuration.getOperation() == DropboxOperation.put) {
            return new DropboxPutProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == DropboxOperation.search) {
            return new DropboxSearchProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == DropboxOperation.del) {
            return new DropboxDelProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == DropboxOperation.get) {
            return new DropboxGetProducer(this, this.configuration);
        }
        if (this.configuration.getOperation() == DropboxOperation.move) {
            return new DropboxMoveProducer(this, this.configuration);
        }
        throw new DropboxException("Operation specified is not valid for producer!");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.trace("Resolve consumer dropbox endpoint {" + this.configuration.getOperation().toString() + "}");
        LOG.trace("Resolve consumer dropbox attached client:" + this.configuration.getClient());
        if (this.configuration.getOperation() == DropboxOperation.search) {
            DropboxScheduledPollSearchConsumer consumer = new DropboxScheduledPollSearchConsumer(this, processor, this.configuration);
            consumer.setDelay(3600000L);
            return consumer;
        }
        if (this.configuration.getOperation() == DropboxOperation.get) {
            DropboxScheduledPollGetConsumer consumer = new DropboxScheduledPollGetConsumer(this, processor, this.configuration);
            consumer.setDelay(3600000L);
            return consumer;
        }
        throw new DropboxException("Operation specified is not valid for consumer!");
    }

    public boolean isSingleton() {
        return true;
    }
}

