/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox;

import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxRequestConfig;
import java.util.Locale;
import org.apache.camel.component.dropbox.util.DropboxOperation;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DropboxConfiguration {
    @UriPath
    @Metadata(required="true")
    private DropboxOperation operation;
    @UriParam
    @Metadata(required="true")
    private String accessToken;
    @UriParam
    private String localPath;
    @UriParam
    private String remotePath;
    @UriParam
    private String newRemotePath;
    @UriParam
    private String query;
    @UriParam
    private DropboxUploadMode uploadMode;
    @UriParam
    @Metadata(required="true")
    private String clientIdentifier;
    @UriParam
    private DbxClient client;

    public void setClient(DbxClient client) {
        this.client = client;
    }

    public DbxClient getClient() {
        return this.client;
    }

    public void createClient() {
        DbxRequestConfig config = new DbxRequestConfig(this.clientIdentifier, Locale.getDefault().toString());
        this.client = new DbxClient(config, this.accessToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getNewRemotePath() {
        return this.newRemotePath;
    }

    public void setNewRemotePath(String newRemotePath) {
        this.newRemotePath = newRemotePath;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    public DropboxOperation getOperation() {
        return this.operation;
    }

    public void setOperation(DropboxOperation operation) {
        this.operation = operation;
    }

    public DropboxUploadMode getUploadMode() {
        return this.uploadMode;
    }

    public void setUploadMode(DropboxUploadMode uploadMode) {
        this.uploadMode = uploadMode;
    }
}

