/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramPacketStringDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private final Charset charset;

    public DatagramPacketStringDecoder() {
        this(Charset.defaultCharset());
    }

    public DatagramPacketStringDecoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            ByteBuf payload = (ByteBuf)msg.content();
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)payload.toString(this.charset), msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        }
    }
}

