/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.authorization.IAuthEvent;
import com.box.boxjavalibv2.authorization.IAuthFlowListener;
import com.box.boxjavalibv2.authorization.IAuthFlowMessage;
import com.box.boxjavalibv2.authorization.IAuthFlowUI;
import com.box.boxjavalibv2.authorization.OAuthDataMessage;
import com.box.boxjavalibv2.authorization.OAuthWebViewData;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.events.OAuthEvent;
import com.box.boxjavalibv2.resourcemanagers.IBoxOAuthManager;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoginAuthFlowUI
implements IAuthFlowUI {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthFlowUI.class);
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("&?([^=]+)=([^&]+)");
    private final BoxConfiguration configuration;
    private final BoxClient boxClient;

    public LoginAuthFlowUI(BoxConfiguration configuration, BoxClient boxClient) {
        this.configuration = configuration;
        this.boxClient = boxClient;
    }

    public void authenticate(IAuthFlowListener listener) {
        WebClient webClient = new WebClient(BrowserVersion.FIREFOX_38);
        WebClientOptions options = webClient.getOptions();
        options.setRedirectEnabled(true);
        options.setJavaScriptEnabled(false);
        options.setThrowExceptionOnFailingStatusCode(true);
        options.setThrowExceptionOnScriptError(true);
        options.setPrintContentOnFailingStatusCode(LOG.isDebugEnabled());
        try {
            SSLContext sslContext = new SSLContextParameters().createSSLContext();
            options.setSSLClientProtocols(sslContext.createSSLEngine().getEnabledProtocols());
        }
        catch (GeneralSecurityException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        new WebConnectionWrapper(webClient){

            public WebResponse getResponse(WebRequest request) throws IOException {
                request.setAdditionalHeader("Accept-Encoding", "identity");
                return super.getResponse(request);
            }
        };
        Map<String, Object> httpParams = this.configuration.getHttpParams();
        if (httpParams != null && httpParams.get("http.route.default-proxy") != null) {
            HttpHost proxyHost = (HttpHost)httpParams.get("http.route.default-proxy");
            Boolean socksProxy = (Boolean)httpParams.get("http.route.socks-proxy");
            ProxyConfig proxyConfig = new ProxyConfig(proxyHost.getHostName(), proxyHost.getPort(), socksProxy != null ? socksProxy : false);
            options.setProxyConfig(proxyConfig);
        }
        try {
            String redirectQuery;
            String csrfId = String.valueOf(new SecureRandom().nextLong());
            OAuthWebViewData viewData = new OAuthWebViewData(this.boxClient.getOAuthDataController());
            viewData.setOptionalState(String.valueOf(csrfId));
            HtmlPage authPage = (HtmlPage)webClient.getPage(viewData.buildUrl().toString());
            HtmlDivision div = (HtmlDivision)authPage.getFirstByXPath("//div[contains(concat(' ', @class, ' '), ' error_message ')]");
            if (div != null) {
                String errorMessage = div.getTextContent().replaceAll("\\s+", " ").replaceAll(" Show Error Details", ":").trim();
                throw new IllegalArgumentException("Error authorizing application: " + errorMessage);
            }
            HtmlForm loginForm = authPage.getFormByName("login_form");
            HtmlTextInput login = (HtmlTextInput)loginForm.getInputByName("login");
            login.setText(this.configuration.getUserName());
            HtmlPasswordInput password = (HtmlPasswordInput)loginForm.getInputByName("password");
            password.setText(this.configuration.getUserPassword());
            HtmlSubmitInput submitInput = (HtmlSubmitInput)loginForm.getInputByName("login_submit");
            HtmlPage consentPage = (HtmlPage)submitInput.click();
            HtmlForm consentForm = consentPage.getFormByName("consent_form");
            HtmlButton consentAccept = consentForm.getButtonByName("consent_accept");
            webClient.getOptions().setRedirectEnabled(false);
            try {
                Page redirectPage = consentAccept.click();
                redirectQuery = redirectPage.getUrl().getQuery();
            }
            catch (FailingHttpStatusCodeException e) {
                if (e.getStatusCode() != 302) {
                    throw e;
                }
                String location = e.getResponse().getResponseHeaderValue("Location");
                redirectQuery = new URL(location).getQuery();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(redirectQuery);
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
            String state = (String)params.get("state");
            if (!csrfId.equals(state)) {
                SecurityException e = new SecurityException("Invalid CSRF code!");
                listener.onAuthFlowException((Exception)e);
            } else {
                String authorizationCode = (String)params.get("code");
                IBoxOAuthManager oAuthManager = this.boxClient.getOAuthManager();
                BoxOAuthToken oAuthToken = oAuthManager.createOAuth(authorizationCode, this.configuration.getClientId(), this.configuration.getClientSecret(), null);
                OAuthDataMessage authDataMessage = new OAuthDataMessage(oAuthToken, this.boxClient.getJSONParser(), this.boxClient.getResourceHub());
                listener.onAuthFlowEvent((IAuthEvent)OAuthEvent.OAUTH_CREATED, (IAuthFlowMessage)authDataMessage);
            }
        }
        catch (Exception e) {
            listener.onAuthFlowException(e);
        }
    }

    public void addAuthFlowListener(IAuthFlowListener listener) {
        throw new UnsupportedOperationException("addAuthFlowListener");
    }

    public void initializeAuthFlow(Object applicationContext, String clientId, String clientSecret) {
        throw new UnsupportedOperationException("initializeAuthFlow");
    }

    public void initializeAuthFlow(Object applicationContext, String clientId, String clientSecret, String redirectUrl) {
        throw new UnsupportedOperationException("initializeAuthFlow");
    }

    public void initializeAuthFlow(Object applicationContext, String clientId, String clientSecret, String redirectUrl, BoxClient boxClient) {
        throw new UnsupportedOperationException("initializeAuthFlow");
    }
}

