/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.BoxConnectionManagerBuilder;
import com.box.boxjavalibv2.BoxRESTClient;
import com.box.boxjavalibv2.authorization.IAuthFlowListener;
import com.box.boxjavalibv2.authorization.IAuthFlowUI;
import com.box.boxjavalibv2.authorization.IAuthSecureStorage;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import com.box.restclientv2.IBoxRESTClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.internal.CachedBoxClient;
import org.apache.camel.component.box.internal.CachingSecureStorage;
import org.apache.camel.component.box.internal.LoginAuthFlowListener;
import org.apache.camel.component.box.internal.LoginAuthFlowUI;
import org.apache.camel.component.box.internal.OAuthHelperListener;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoxClientHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BoxClientHelper.class);

    private BoxClientHelper() {
    }

    public static CachedBoxClient createBoxClient(final BoxConfiguration configuration) {
        String clientId = configuration.getClientId();
        String clientSecret = configuration.getClientSecret();
        IAuthSecureStorage authSecureStorage = configuration.getAuthSecureStorage();
        String userName = configuration.getUserName();
        String userPassword = configuration.getUserPassword();
        if (authSecureStorage == null && ObjectHelper.isEmpty((Object)userPassword) || ObjectHelper.isEmpty((Object)userName) || ObjectHelper.isEmpty((Object)clientId) || ObjectHelper.isEmpty((Object)clientSecret)) {
            throw new IllegalArgumentException("Missing one or more required properties clientId, clientSecret, userName and either authSecureStorage or userPassword");
        }
        LOG.debug("Creating BoxClient for login:{}, client_id:{} ...", (Object)userName, (Object)clientId);
        BoxConnectionManagerBuilder connectionManagerBuilder = configuration.getConnectionManagerBuilder();
        BoxConnectionManagerBuilder connectionManager = connectionManagerBuilder != null ? connectionManagerBuilder : new BoxConnectionManagerBuilder();
        final ClientConnectionManager[] clientConnectionManager = new ClientConnectionManager[1];
        BoxRESTClient restClient = new BoxRESTClient(connectionManager.build()){

            public HttpClient getRawHttpClient() {
                SSLContext sslContext;
                HttpClient httpClient = super.getRawHttpClient();
                clientConnectionManager[0] = httpClient.getConnectionManager();
                SchemeRegistry schemeRegistry = clientConnectionManager[0].getSchemeRegistry();
                SSLContextParameters sslContextParameters = configuration.getSslContextParameters();
                if (sslContextParameters == null) {
                    sslContextParameters = new SSLContextParameters();
                }
                Map<String, Object> configParams = configuration.getHttpParams();
                boolean useSocksProxy = false;
                HttpHost proxyHost = null;
                if (configParams != null && !configParams.isEmpty()) {
                    Boolean socksProxy = (Boolean)configParams.get("http.route.socks-proxy");
                    if (socksProxy != null && socksProxy.booleanValue()) {
                        useSocksProxy = true;
                        proxyHost = (HttpHost)configParams.get("http.route.default-proxy");
                    }
                    LOG.debug("Setting {} HTTP Params", (Object)configParams.size());
                    HttpParams httpParams = httpClient.getParams();
                    for (Map.Entry<String, Object> param : configParams.entrySet()) {
                        if (useSocksProxy && (param.getKey().equals("http.route.socks-proxy") || param.getKey().equals("http.route.default-proxy"))) continue;
                        httpParams.setParameter(param.getKey(), param.getValue());
                    }
                }
                try {
                    sslContext = sslContextParameters.createSSLContext();
                }
                catch (IOException e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
                SocksSSLSocketFactory socketFactory = useSocksProxy ? new SocksSSLSocketFactory(sslContext, proxyHost) : new SSLSocketFactory(sslContext, SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                schemeRegistry.register(new Scheme("https", (SocketFactory)socketFactory, 443));
                return httpClient;
            }
        };
        BoxClient boxClient = new BoxClient(clientId, clientSecret, null, null, (IBoxRESTClient)restClient, configuration.getBoxConfig());
        boxClient.setAutoRefreshOAuth(true);
        CachingSecureStorage storage = new CachingSecureStorage(authSecureStorage);
        OAuthHelperListener listener = new OAuthHelperListener(storage, configuration.getRefreshListener());
        boxClient.addOAuthRefreshListener((OAuthRefreshListener)listener);
        CachedBoxClient cachedBoxClient = new CachedBoxClient(boxClient, userName, clientId, storage, listener, clientConnectionManager);
        LOG.debug("BoxClient created {}", (Object)cachedBoxClient);
        return cachedBoxClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getOAuthToken(BoxConfiguration configuration, CachedBoxClient cachedBoxClient) throws Exception {
        BoxClient boxClient;
        BoxClient boxClient2 = boxClient = cachedBoxClient.getBoxClient();
        synchronized (boxClient2) {
            if (boxClient.isAuthenticated()) {
                return;
            }
            LOG.debug("Getting OAuth token for {}...", (Object)cachedBoxClient);
            CachingSecureStorage authSecureStorage = cachedBoxClient.getSecureStorage();
            if (authSecureStorage != null && authSecureStorage.getAuth() != null) {
                LOG.debug("Using secure storage for {}", (Object)cachedBoxClient);
                boxClient.authenticateFromSecureStorage((IAuthSecureStorage)authSecureStorage);
            } else {
                LOG.debug("Using OAuth {}", (Object)cachedBoxClient);
                LoginAuthFlowUI authFlowUI = new LoginAuthFlowUI(configuration, boxClient);
                CountDownLatch latch = new CountDownLatch(1);
                LoginAuthFlowListener listener = new LoginAuthFlowListener(latch);
                boxClient.authenticate((IAuthFlowUI)authFlowUI, true, (IAuthFlowListener)listener);
                if (!latch.await(configuration.getLoginTimeout(), TimeUnit.SECONDS) && !boxClient.isAuthenticated()) {
                    throw new RuntimeCamelException(String.format("Login timeout for %s", cachedBoxClient));
                }
                Exception ex = listener.getException();
                if (ex != null) {
                    throw new RuntimeCamelException(String.format("Login error for %s: %s", cachedBoxClient, ex.getMessage()), (Throwable)ex);
                }
            }
            LOG.debug("OAuth token created for {}", (Object)cachedBoxClient);
            cachedBoxClient.getListener().onRefresh(boxClient.getAuthData());
        }
    }

    public static void closeIdleConnections(CachedBoxClient cachedBoxClient) {
        ClientConnectionManager connectionManager = cachedBoxClient.getClientConnectionManager();
        if (connectionManager != null) {
            connectionManager.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownBoxClient(BoxConfiguration configuration, CachedBoxClient cachedBoxClient) throws Exception {
        BoxClient boxClient;
        BoxClient boxClient2 = boxClient = cachedBoxClient.getBoxClient();
        synchronized (boxClient2) {
            LOG.debug("Shutting down {} ...", (Object)cachedBoxClient);
            try {
                if (configuration.isRevokeOnShutdown()) {
                    BoxClientHelper.revokeOAuthToken(configuration, cachedBoxClient);
                }
            }
            finally {
                boxClient.setConnectionOpen(false);
                ClientConnectionManager connectionManager = cachedBoxClient.getClientConnectionManager();
                if (connectionManager != null) {
                    LOG.debug("Closing connections for {}", (Object)cachedBoxClient);
                    connectionManager.shutdown();
                } else {
                    LOG.debug("ConnectionManager not created for {}", (Object)cachedBoxClient);
                }
            }
            LOG.debug("Shutdown successful for {}", (Object)cachedBoxClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void revokeOAuthToken(BoxConfiguration configuration, CachedBoxClient cachedBoxClient) throws Exception {
        BoxClient boxClient;
        BoxClient boxClient2 = boxClient = cachedBoxClient.getBoxClient();
        synchronized (boxClient2) {
            if (boxClient.isAuthenticated()) {
                LOG.debug("Revoking OAuth refresh token for {}", (Object)cachedBoxClient);
                boxClient.getOAuthManager().revokeOAuth(boxClient.getAuthData().getAccessToken(), configuration.getClientId(), configuration.getClientSecret());
                cachedBoxClient.getListener().onRefresh(null);
                boxClient.getOAuthDataController().setOAuthData(null);
            }
        }
    }

    static class SocksSSLSocketFactory
    extends SSLSocketFactory {
        HttpHost proxyHost;

        SocksSSLSocketFactory(SSLContext sslContext, HttpHost proxyHost) {
            super(sslContext, SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            this.proxyHost = proxyHost;
        }

        public Socket createSocket(HttpContext context) throws IOException {
            InetSocketAddress socksaddr = new InetSocketAddress(this.proxyHost.getHostName(), this.proxyHost.getPort());
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
            return new Socket(proxy);
        }
    }
}

