/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.IBoxCollaborationsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxCommentsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxEventsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFilesManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxFoldersManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxGroupsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxSearchManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxSharedItemsManagerEndpointConfiguration;
import org.apache.camel.component.box.IBoxUsersManagerEndpointConfiguration;
import org.apache.camel.component.box.LongPollingEventsManagerEndpointConfiguration;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.IBoxCollaborationsManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxCommentsManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxEventsManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxFilesManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxFoldersManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxGroupsManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxSearchManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxSharedItemsManagerApiMethod;
import org.apache.camel.component.box.internal.IBoxUsersManagerApiMethod;
import org.apache.camel.component.box.internal.LongPollingEventsManagerApiMethod;
import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.component.ApiMethodHelper;

public final class BoxApiCollection
extends ApiCollection<BoxApiName, BoxConfiguration> {
    private static BoxApiCollection collection;

    private BoxApiCollection() {
        HashMap<String, String> aliases = new HashMap<String, String>();
        HashMap<BoxApiName, ApiMethodHelper> apiHelpers = new HashMap<BoxApiName, ApiMethodHelper>();
        HashMap<Class<IBoxUsersManagerApiMethod>, BoxApiName> apiMethods = new HashMap<Class<IBoxUsersManagerApiMethod>, BoxApiName>();
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        List<String> nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.COLLABORATIONS, new ApiMethodHelper(IBoxCollaborationsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCollaborationsManagerApiMethod.class, BoxApiName.COLLABORATIONS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.COMMENTS, new ApiMethodHelper(IBoxCommentsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCommentsManagerApiMethod.class, BoxApiName.COMMENTS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.EVENTS, new ApiMethodHelper(IBoxEventsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxEventsManagerApiMethod.class, BoxApiName.EVENTS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.FILES, new ApiMethodHelper(IBoxFilesManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFilesManagerApiMethod.class, BoxApiName.FILES);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.FOLDERS, new ApiMethodHelper(IBoxFoldersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFoldersManagerApiMethod.class, BoxApiName.FOLDERS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.GROUPS, new ApiMethodHelper(IBoxGroupsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxGroupsManagerApiMethod.class, BoxApiName.GROUPS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(BoxApiName.POLL_EVENTS, new ApiMethodHelper(LongPollingEventsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(LongPollingEventsManagerApiMethod.class, BoxApiName.POLL_EVENTS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.SEARCH, new ApiMethodHelper(IBoxSearchManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxSearchManagerApiMethod.class, BoxApiName.SEARCH);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.SHARED_COMMENTS, new ApiMethodHelper(IBoxCommentsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxCommentsManagerApiMethod.class, BoxApiName.SHARED_COMMENTS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.SHARED_FILES, new ApiMethodHelper(IBoxFilesManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFilesManagerApiMethod.class, BoxApiName.SHARED_FILES);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.SHARED_FOLDERS, new ApiMethodHelper(IBoxFoldersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxFoldersManagerApiMethod.class, BoxApiName.SHARED_FOLDERS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|delete|update)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.SHARED_ITEMS, new ApiMethodHelper(IBoxSharedItemsManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxSharedItemsManagerApiMethod.class, BoxApiName.SHARED_ITEMS);
        aliases.clear();
        aliases.put("[gs]et(.+)", "$1");
        aliases.put("(create|update|upload|download)\\w+", "$1");
        nullableArgs = Arrays.asList("defaultRequest");
        apiHelpers.put(BoxApiName.USERS, new ApiMethodHelper(IBoxUsersManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(IBoxUsersManagerApiMethod.class, BoxApiName.USERS);
        this.setApiHelpers(apiHelpers);
        this.setApiMethods(apiMethods);
    }

    public BoxConfiguration getEndpointConfiguration(BoxApiName apiName) {
        BoxConfiguration result = null;
        switch (apiName) {
            case COLLABORATIONS: {
                result = new IBoxCollaborationsManagerEndpointConfiguration();
                break;
            }
            case COMMENTS: {
                result = new IBoxCommentsManagerEndpointConfiguration();
                break;
            }
            case EVENTS: {
                result = new IBoxEventsManagerEndpointConfiguration();
                break;
            }
            case FILES: {
                result = new IBoxFilesManagerEndpointConfiguration();
                break;
            }
            case FOLDERS: {
                result = new IBoxFoldersManagerEndpointConfiguration();
                break;
            }
            case GROUPS: {
                result = new IBoxGroupsManagerEndpointConfiguration();
                break;
            }
            case POLL_EVENTS: {
                result = new LongPollingEventsManagerEndpointConfiguration();
                break;
            }
            case SEARCH: {
                result = new IBoxSearchManagerEndpointConfiguration();
                break;
            }
            case SHARED_COMMENTS: {
                result = new IBoxCommentsManagerEndpointConfiguration();
                break;
            }
            case SHARED_FILES: {
                result = new IBoxFilesManagerEndpointConfiguration();
                break;
            }
            case SHARED_FOLDERS: {
                result = new IBoxFoldersManagerEndpointConfiguration();
                break;
            }
            case SHARED_ITEMS: {
                result = new IBoxSharedItemsManagerEndpointConfiguration();
                break;
            }
            case USERS: {
                result = new IBoxUsersManagerEndpointConfiguration();
            }
        }
        return result;
    }

    public static synchronized BoxApiCollection getCollection() {
        if (collection == null) {
            collection = new BoxApiCollection();
        }
        return collection;
    }
}

