/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.util.StringHelper;

@Converter
public final class BoxConverter {
    private static final String PROPERTY_FOLDER_ID_DELIMITED = "CamelBox.folderId";
    private static final String PROPERTY_FOLDER_ID = "CamelBox.".substring(0, "CamelBox.".length() - 1) + "FolderId";
    private static final String ROOT_FOLDER = "0";
    private static final DateFormat ISO8601;

    private BoxConverter() {
    }

    @Converter
    public static BoxFileUploadRequestObject genericFileToBoxFileUploadRequestObject(GenericFile<?> file, Exchange exchange) throws Exception {
        String folderId = ROOT_FOLDER;
        if (exchange != null && exchange.getIn() != null) {
            folderId = (String)exchange.getIn().getHeader(PROPERTY_FOLDER_ID_DELIMITED, (Object)folderId, String.class);
            folderId = (String)exchange.getIn().getHeader(PROPERTY_FOLDER_ID, (Object)folderId, String.class);
        }
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            return BoxFileUploadRequestObject.uploadFileRequestObject((String)folderId, (String)file.getFileName(), (File)f);
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
            return BoxFileUploadRequestObject.uploadFileRequestObject((String)folderId, (String)file.getFileName(), (InputStream)is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Converter
    public static BoxFileUploadRequestObject toBox(byte[] data, Exchange exchange) throws Exception {
        String fileName;
        String folderId = ROOT_FOLDER;
        if (exchange != null && exchange.getIn() != null) {
            folderId = (String)exchange.getIn().getHeader(PROPERTY_FOLDER_ID_DELIMITED, (Object)folderId, String.class);
            folderId = (String)exchange.getIn().getHeader(PROPERTY_FOLDER_ID, (Object)folderId, String.class);
            fileName = (String)exchange.getIn().getHeader("CamelFileName", (Object)StringHelper.sanitize((String)exchange.getIn().getMessageId()), String.class);
        } else {
            Class<BoxConverter> clazz = BoxConverter.class;
            // MONITORENTER : org.apache.camel.component.box.BoxConverter.class
            fileName = "CamelBox" + ISO8601.format(new Date()) + ".bin";
            // MONITOREXIT : clazz
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        return BoxFileUploadRequestObject.uploadFileRequestObject((String)folderId, (String)fileName, (InputStream)is);
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss'Z'");
        ISO8601.setTimeZone(tz);
    }
}

