/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import com.box.boxjavalibv2.BoxConnectionManagerBuilder;
import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.authorization.IAuthSecureStorage;
import com.box.boxjavalibv2.authorization.OAuthRefreshListener;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriParams
public class BoxConfiguration {
    @UriPath
    @Metadata(required="true")
    private BoxApiName apiName;
    @UriPath
    @Metadata(required="true")
    private String methodName;
    @UriParam
    private String clientId;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String userName;
    @UriParam(label="security", secret=true)
    private String userPassword;
    @UriParam(label="advanced,security")
    private IAuthSecureStorage authSecureStorage;
    @UriParam(label="advanced")
    private OAuthRefreshListener refreshListener;
    @UriParam
    private boolean revokeOnShutdown;
    @UriParam
    private String sharedLink;
    @UriParam
    private String sharedPassword;
    @UriParam(label="advanced")
    private IBoxConfig boxConfig;
    @UriParam(label="advanced")
    private BoxConnectionManagerBuilder connectionManagerBuilder;
    @UriParam(label="advanced")
    private Map<String, Object> httpParams;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(defaultValue="30")
    private int loginTimeout = 30;

    public BoxApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(BoxApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public IAuthSecureStorage getAuthSecureStorage() {
        return this.authSecureStorage;
    }

    public void setAuthSecureStorage(IAuthSecureStorage authSecureStorage) {
        this.authSecureStorage = authSecureStorage;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public OAuthRefreshListener getRefreshListener() {
        return this.refreshListener;
    }

    public void setRefreshListener(OAuthRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }

    public boolean isRevokeOnShutdown() {
        return this.revokeOnShutdown;
    }

    public void setRevokeOnShutdown(boolean revokeOnShutdown) {
        this.revokeOnShutdown = revokeOnShutdown;
    }

    public String getSharedLink() {
        return this.sharedLink;
    }

    public void setSharedLink(String sharedLink) {
        this.sharedLink = sharedLink;
    }

    public String getSharedPassword() {
        return this.sharedPassword;
    }

    public void setSharedPassword(String sharedPassword) {
        this.sharedPassword = sharedPassword;
    }

    public IBoxConfig getBoxConfig() {
        return this.boxConfig;
    }

    public void setBoxConfig(IBoxConfig boxConfig) {
        this.boxConfig = boxConfig;
    }

    public BoxConnectionManagerBuilder getConnectionManagerBuilder() {
        return this.connectionManagerBuilder;
    }

    public void setConnectionManagerBuilder(BoxConnectionManagerBuilder connectionManagerBuilder) {
        this.connectionManagerBuilder = connectionManagerBuilder;
    }

    public Map<String, Object> getHttpParams() {
        return this.httpParams;
    }

    public void setHttpParams(Map<String, Object> httpParams) {
        this.httpParams = httpParams;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoxConfiguration) {
            BoxConfiguration other = (BoxConfiguration)obj;
            return this.boxConfig == other.boxConfig && this.connectionManagerBuilder == other.connectionManagerBuilder && this.httpParams == other.httpParams && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && this.authSecureStorage == other.authSecureStorage;
        }
        return false;
    }
}

