/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.component.box.BoxEndpoint;
import org.apache.camel.component.box.internal.BoxApiCollection;
import org.apache.camel.component.box.internal.BoxApiName;
import org.apache.camel.component.box.internal.BoxClientHelper;
import org.apache.camel.component.box.internal.CachedBoxClient;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class BoxComponent
extends AbstractApiComponent<BoxApiName, BoxConfiguration, BoxApiCollection> {
    private CachedBoxClient cachedBoxClient;

    public BoxComponent() {
        super(BoxEndpoint.class, BoxApiName.class, (ApiCollection)BoxApiCollection.getCollection());
    }

    public BoxComponent(CamelContext context) {
        super(context, BoxEndpoint.class, BoxApiName.class, (ApiCollection)BoxApiCollection.getCollection());
    }

    protected BoxApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return BoxApiName.fromValue(apiNameStr);
    }

    protected Endpoint createEndpoint(String uri, String methodName, BoxApiName apiName, BoxConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new BoxEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public CachedBoxClient getBoxClient() {
        return this.cachedBoxClient;
    }

    public void setConfiguration(BoxConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public BoxConfiguration getConfiguration() {
        return (BoxConfiguration)super.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.cachedBoxClient == null && this.configuration != null) {
            this.cachedBoxClient = BoxClientHelper.createBoxClient((BoxConfiguration)this.configuration);
        }
    }

    protected void doStop() throws Exception {
        if (this.cachedBoxClient != null) {
            BoxClientHelper.closeIdleConnections(this.cachedBoxClient);
        }
    }

    public void doShutdown() throws Exception {
        try {
            if (this.cachedBoxClient != null) {
                BoxClientHelper.shutdownBoxClient((BoxConfiguration)this.configuration, this.cachedBoxClient);
            }
        }
        finally {
            this.cachedBoxClient = null;
            super.doShutdown();
        }
    }
}

