/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.mllp.MllpAcknowledgementDeliveryException;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.MllpInvalidMessageException;
import org.apache.camel.component.mllp.impl.Hl7Util;
import org.apache.camel.component.mllp.impl.MllpBufferedSocketWriter;
import org.apache.camel.component.mllp.impl.MllpSocketReader;
import org.apache.camel.component.mllp.impl.MllpSocketUtil;
import org.apache.camel.component.mllp.impl.MllpSocketWriter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerationException;
import org.apache.camel.processor.mllp.Hl7AcknowledgementGenerator;
import org.apache.camel.util.IOHelper;
import org.slf4j.MDC;

public class MllpTcpServerConsumer
extends DefaultConsumer {
    public static final int SOCKET_STARTUP_TEST_WAIT = 100;
    public static final int SOCKET_STARTUP_TEST_READ_TIMEOUT = 250;
    ServerSocketThread serverSocketThread;
    List<ClientSocketThread> clientThreads = new LinkedList<ClientSocketThread>();
    Hl7AcknowledgementGenerator acknowledgementGenerator = new Hl7AcknowledgementGenerator();
    private final MllpEndpoint endpoint;

    public MllpTcpServerConsumer(MllpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.log.trace("MllpTcpServerConsumer(endpoint, processor)");
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.log.debug("doStart() - creating acceptor thread");
        ServerSocket serverSocket = new ServerSocket();
        if (null != this.endpoint.receiveBufferSize) {
            serverSocket.setReceiveBufferSize(this.endpoint.receiveBufferSize);
        }
        serverSocket.setReuseAddress(this.endpoint.reuseAddress);
        serverSocket.setSoTimeout(this.endpoint.acceptTimeout);
        InetSocketAddress socketAddress = null == this.endpoint.getHostname() ? new InetSocketAddress(this.endpoint.getPort()) : new InetSocketAddress(this.endpoint.getHostname(), this.endpoint.getPort());
        long startTicks = System.currentTimeMillis();
        do {
            try {
                serverSocket.bind(socketAddress, this.endpoint.backlog);
            }
            catch (BindException bindException) {
                if (System.currentTimeMillis() > startTicks + (long)this.endpoint.getBindTimeout()) {
                    this.log.error("Failed to bind to address {} within timeout {}", (Object)socketAddress, (Object)this.endpoint.getBindTimeout());
                    throw bindException;
                }
                this.log.warn("Failed to bind to address {} - retrying in {} milliseconds", (Object)socketAddress, (Object)this.endpoint.getBindRetryInterval());
                Thread.sleep(this.endpoint.getBindRetryInterval());
            }
        } while (!serverSocket.isBound());
        this.serverSocketThread = new ServerSocketThread(serverSocket);
        this.serverSocketThread.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.debug("doStop()");
        for (ClientSocketThread clientSocketThread : this.clientThreads) {
            clientSocketThread.interrupt();
        }
        switch (this.serverSocketThread.getState()) {
            case TERMINATED: {
                break;
            }
            default: {
                this.serverSocketThread.interrupt();
            }
        }
        this.serverSocketThread = null;
        super.doStop();
    }

    class ClientSocketThread
    extends Thread {
        final Socket clientSocket;
        final MllpSocketReader mllpSocketReader;
        final MllpSocketWriter mllpSocketWriter;
        Integer initialByte;

        ClientSocketThread(Socket clientSocket, Integer initialByte) throws IOException {
            this.initialByte = initialByte;
            this.setName(this.createThreadName(clientSocket));
            this.clientSocket = clientSocket;
            this.clientSocket.setKeepAlive(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.keepAlive);
            this.clientSocket.setTcpNoDelay(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.tcpNoDelay);
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize) {
                this.clientSocket.setReceiveBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveBufferSize);
            }
            if (null != ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize) {
                this.clientSocket.setSendBufferSize(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.sendBufferSize);
            }
            this.clientSocket.setReuseAddress(((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.reuseAddress);
            this.clientSocket.setSoLinger(false, -1);
            MllpSocketUtil.setSoTimeout(clientSocket, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout, MllpTcpServerConsumer.this.log, "Constructing ClientSocketThread");
            this.mllpSocketReader = new MllpSocketReader(this.clientSocket, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.readTimeout, false);
            this.mllpSocketWriter = ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.bufferWrites ? new MllpBufferedSocketWriter(this.clientSocket, true) : new MllpSocketWriter(this.clientSocket, true);
        }

        String createThreadName(Socket socket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s -> %s", className, endpointKey, socket.getLocalSocketAddress(), socket.getRemoteSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int receiveTimeoutCounter = 0;
            MDC.put((String)"camel.contextId", (String)MllpTcpServerConsumer.this.endpoint.getCamelContext().getName());
            while (!this.isInterrupted() && null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                byte[] hl7MessageBytes = null;
                MllpTcpServerConsumer.this.log.debug("Checking for data ....");
                try {
                    hl7MessageBytes = this.mllpSocketReader.readEnvelopedPayload(this.initialByte);
                    if (hl7MessageBytes == null) {
                        if (((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.maxReceiveTimeouts <= 0 || ++receiveTimeoutCounter < ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.maxReceiveTimeouts) continue;
                        String reasonMessage = String.format("Idle Client after %d receive timeouts [%d-milliseconds] - resetting connection", receiveTimeoutCounter, ((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.receiveTimeout);
                        MllpSocketUtil.reset(this.clientSocket, MllpTcpServerConsumer.this.log, reasonMessage);
                        continue;
                    }
                }
                catch (MllpException mllpEx) {
                    Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                    exchange.setException((Throwable)mllpEx);
                    MllpTcpServerConsumer.this.log.warn("Exception encountered reading payload - sending exception to route", (Throwable)mllpEx);
                    try {
                        MllpTcpServerConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        MllpTcpServerConsumer.this.log.error("Exception encountered processing exchange with exception encounter reading payload", (Throwable)e);
                    }
                    continue;
                }
                finally {
                    this.initialByte = null;
                    continue;
                }
                MllpTcpServerConsumer.this.log.debug("Populating the exchange with received message");
                Exchange exchange = MllpTcpServerConsumer.this.endpoint.createExchange(ExchangePattern.InOut);
                try {
                    String exceptionMessage;
                    MllpTcpServerConsumer.this.createUoW(exchange);
                    Message message = exchange.getIn();
                    message.setBody((Object)hl7MessageBytes, byte[].class);
                    message.setHeader("CamelMllpLocalAddress", (Object)this.clientSocket.getLocalAddress().toString());
                    message.setHeader("CamelMllpRemoteAddress", (Object)this.clientSocket.getRemoteSocketAddress());
                    message.setHeader("CamelMllpAutoAcknowledge", (Object)((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.autoAck);
                    if (((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.validatePayload && (exceptionMessage = Hl7Util.generateInvalidPayloadExceptionMessage(hl7MessageBytes)) != null) {
                        exchange.setException((Throwable)new MllpInvalidMessageException(exceptionMessage, hl7MessageBytes));
                    }
                    this.populateHl7DataHeaders(exchange, message, hl7MessageBytes);
                    MllpTcpServerConsumer.this.log.debug("Calling processor");
                    try {
                        MllpTcpServerConsumer.this.getProcessor().process(exchange);
                        this.sendAcknowledgement(hl7MessageBytes, exchange);
                    }
                    catch (RuntimeException runtimeEx) {
                        throw runtimeEx;
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.error("Unexpected exception processing exchange", (Throwable)ex);
                    }
                }
                catch (Exception uowEx) {
                    exchange.setException((Throwable)uowEx);
                    MllpTcpServerConsumer.this.log.warn("Exception encountered creating Unit of Work - sending exception to route", (Throwable)uowEx);
                    try {
                        MllpTcpServerConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        MllpTcpServerConsumer.this.log.error("Exception encountered processing exchange with exception encountered createing Unit of Work", (Throwable)e);
                    }
                }
                finally {
                    if (exchange == null) continue;
                    MllpTcpServerConsumer.this.doneUoW(exchange);
                }
            }
            MllpTcpServerConsumer.this.log.debug("ClientSocketThread exiting");
        }

        private void sendAcknowledgement(byte[] originalHl7MessageBytes, Exchange exchange) {
            String acknowledgementMessageType;
            byte[] acknowledgementMessageBytes;
            block32: {
                MllpTcpServerConsumer.this.log.info("sendAcknowledgement");
                if (((Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                    String reasonMessage = String.format("Exchange property %s is %b", "CamelMllpResetConnectionBeforeSend", exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE));
                    MllpSocketUtil.reset(this.clientSocket, MllpTcpServerConsumer.this.log, reasonMessage);
                    return;
                }
                if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
                    String reasonMessage = String.format("Exchange property %s is %b", "CamelMllpCloseConnectionBeforeSend", exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE));
                    MllpSocketUtil.close(this.clientSocket, MllpTcpServerConsumer.this.log, reasonMessage);
                    return;
                }
                acknowledgementMessageBytes = (byte[])exchange.getProperty("CamelMllpAcknowledgement", byte[].class);
                acknowledgementMessageType = null;
                if (null == acknowledgementMessageBytes) {
                    boolean autoAck = (Boolean)exchange.getProperty("CamelMllpAutoAcknowledge", (Object)true, Boolean.TYPE);
                    if (!autoAck) {
                        exchange.setException((Throwable)new MllpInvalidAcknowledgementException("Automatic Acknowledgement is disabled and the CamelMllpAcknowledgement exchange property is null or cannot be converted to byte[]", originalHl7MessageBytes, acknowledgementMessageBytes));
                        return;
                    }
                    String acknowledgmentTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class);
                    try {
                        if (null == acknowledgmentTypeProperty) {
                            if (null == exchange.getException()) {
                                acknowledgementMessageType = "AA";
                                acknowledgementMessageBytes = MllpTcpServerConsumer.this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(originalHl7MessageBytes);
                            } else {
                                acknowledgementMessageType = "AE";
                                acknowledgementMessageBytes = MllpTcpServerConsumer.this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(originalHl7MessageBytes);
                            }
                            break block32;
                        }
                        switch (acknowledgmentTypeProperty) {
                            case "AA": {
                                acknowledgementMessageType = "AA";
                                acknowledgementMessageBytes = MllpTcpServerConsumer.this.acknowledgementGenerator.generateApplicationAcceptAcknowledgementMessage(originalHl7MessageBytes);
                                break;
                            }
                            case "AE": {
                                acknowledgementMessageType = "AE";
                                acknowledgementMessageBytes = MllpTcpServerConsumer.this.acknowledgementGenerator.generateApplicationErrorAcknowledgementMessage(originalHl7MessageBytes);
                                break;
                            }
                            case "AR": {
                                acknowledgementMessageType = "AR";
                                acknowledgementMessageBytes = MllpTcpServerConsumer.this.acknowledgementGenerator.generateApplicationRejectAcknowledgementMessage(originalHl7MessageBytes);
                                break;
                            }
                            default: {
                                exchange.setException((Throwable)new Hl7AcknowledgementGenerationException("Unsupported acknowledgment type: " + acknowledgmentTypeProperty));
                                return;
                            }
                        }
                    }
                    catch (Hl7AcknowledgementGenerationException ackGenerationException) {
                        exchange.setProperty("CamelMllpAcknowledgementException", (Object)ackGenerationException);
                        exchange.setException((Throwable)ackGenerationException);
                    }
                } else {
                    int bM = 77;
                    int bS = 83;
                    int bA = 65;
                    int bE = 69;
                    int bR = 82;
                    byte fieldSeparator = originalHl7MessageBytes[3];
                    for (int i = 0; i < originalHl7MessageBytes.length; ++i) {
                        String acknowledgementTypeProperty;
                        if (13 != i || i + 7 >= originalHl7MessageBytes.length || 77 != originalHl7MessageBytes[i + 1] || 83 != originalHl7MessageBytes[i + 2] || 65 != originalHl7MessageBytes[i + 3] || fieldSeparator != originalHl7MessageBytes[i + 4]) continue;
                        if (fieldSeparator != originalHl7MessageBytes[i + 7]) {
                            MllpTcpServerConsumer.this.log.warn("MSA-1 is longer than 2-bytes - ignoring trailing bytes");
                        }
                        byte[] acknowledgmentTypeBytes = new byte[]{originalHl7MessageBytes[i + 5], originalHl7MessageBytes[i + 6]};
                        try {
                            acknowledgementMessageType = IOConverter.toString((byte[])acknowledgmentTypeBytes, (Exchange)exchange);
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException("Failed to convert acknowledgement message to string", ioEx);
                        }
                        if (65 != acknowledgmentTypeBytes[0]) {
                            switch (acknowledgementMessageBytes[1]) {
                                case 65: 
                                case 69: 
                                case 82: {
                                    break;
                                }
                                default: {
                                    MllpTcpServerConsumer.this.log.warn("Invalid acknowledgement type [" + acknowledgementMessageType + "] found in message - should be AA, AE or AR");
                                }
                            }
                        }
                        if (null == (acknowledgementTypeProperty = (String)exchange.getProperty("CamelMllpAcknowledgementType", String.class)) || acknowledgementTypeProperty.equals(acknowledgementMessageType)) continue;
                        MllpTcpServerConsumer.this.log.warn("Acknowledgement type found in message [" + acknowledgementMessageType + "] does not match " + "CamelMllpAcknowledgementType" + " exchange property value [" + acknowledgementTypeProperty + "] - using value found in message");
                    }
                }
            }
            Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            message.setHeader("CamelMllpAcknowledgement", (Object)acknowledgementMessageBytes);
            message.setHeader("CamelMllpAcknowledgementString", (Object)new String(acknowledgementMessageBytes));
            message.setHeader("CamelMllpAcknowledgementType", (Object)acknowledgementMessageType);
            MllpTcpServerConsumer.this.log.debug("Sending Acknowledgement: {}", (Object)MllpComponent.covertBytesToPrintFriendlyString(acknowledgementMessageBytes));
            try {
                this.mllpSocketWriter.writeEnvelopedPayload(originalHl7MessageBytes, acknowledgementMessageBytes);
            }
            catch (MllpException mllpEx) {
                MllpTcpServerConsumer.this.log.error("MLLP Acknowledgement failure: {}", (Throwable)mllpEx);
                MllpAcknowledgementDeliveryException deliveryException = new MllpAcknowledgementDeliveryException(originalHl7MessageBytes, acknowledgementMessageBytes, (Throwable)mllpEx);
                exchange.setProperty("CamelMllpAcknowledgementException", (Object)deliveryException);
                exchange.setException((Throwable)deliveryException);
            }
            if (((Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
                String reasonMessage = String.format("Exchange property %s is %b", "CamelMllpResetConnectionAfterSend", exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE));
                MllpSocketUtil.reset(this.clientSocket, MllpTcpServerConsumer.this.log, reasonMessage);
                return;
            }
            if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
                String reasonMessage = String.format("Exchange property %s is %b", "CamelMllpCloseConnectionAfterSend", exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE));
                MllpSocketUtil.reset(this.clientSocket, MllpTcpServerConsumer.this.log, reasonMessage);
            }
        }

        private void populateHl7DataHeaders(Exchange exchange, Message message, byte[] hl7MessageBytes) {
            if (hl7MessageBytes == null || hl7MessageBytes.length < 8) {
                return;
            }
            byte fieldSeparator = hl7MessageBytes[3];
            int endOfMSH = -1;
            ArrayList<Integer> fieldSeparatorIndexes = new ArrayList<Integer>(10);
            for (int i = 0; i < hl7MessageBytes.length; ++i) {
                if (fieldSeparator == hl7MessageBytes[i]) {
                    fieldSeparatorIndexes.add(i);
                    continue;
                }
                if (13 != hl7MessageBytes[i]) continue;
                if (fieldSeparator != hl7MessageBytes[i - 1]) {
                    fieldSeparatorIndexes.add(i);
                }
                endOfMSH = i;
                break;
            }
            String messageBodyForDebugging = new String(hl7MessageBytes);
            if (-1 == endOfMSH) {
                MllpTcpServerConsumer.this.log.error("Population of message headers failed - unable to find the end of the MSH segment");
            } else if (((MllpTcpServerConsumer)MllpTcpServerConsumer.this).endpoint.hl7Headers) {
                MllpTcpServerConsumer.this.log.debug("Populating the HL7 message headers");
                Charset charset = Charset.forName(IOHelper.getCharsetName((Exchange)exchange));
                block14: for (int i = 2; i < fieldSeparatorIndexes.size(); ++i) {
                    int startingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i - 1);
                    int endingFieldSeparatorIndex = (Integer)fieldSeparatorIndexes.get(i);
                    if (endingFieldSeparatorIndex - startingFieldSeparatorIndex <= 1) continue;
                    String headerName = null;
                    switch (i) {
                        case 2: {
                            headerName = "CamelMllpSendingApplication";
                            break;
                        }
                        case 3: {
                            headerName = "CamelMllpSendingFacility";
                            break;
                        }
                        case 4: {
                            headerName = "CamelMllpReceivingApplication";
                            break;
                        }
                        case 5: {
                            headerName = "CamelMllpReceivingFacility";
                            break;
                        }
                        case 6: {
                            headerName = "CamelMllpTimestamp";
                            break;
                        }
                        case 7: {
                            headerName = "CamelMllpSecurity";
                            break;
                        }
                        case 8: {
                            headerName = "CamelMllpMessageType";
                            break;
                        }
                        case 9: {
                            headerName = "CamelMllpMessageControlId";
                            break;
                        }
                        case 10: {
                            headerName = "CamelMllpProcessingId";
                            break;
                        }
                        case 11: {
                            headerName = "CamelMllpVersionId";
                            break;
                        }
                        case 17: {
                            headerName = "CamelMllpCharset";
                            break;
                        }
                        default: {
                            continue block14;
                        }
                    }
                    String headerValue = new String(hl7MessageBytes, startingFieldSeparatorIndex + 1, endingFieldSeparatorIndex - startingFieldSeparatorIndex - 1, charset);
                    message.setHeader(headerName, (Object)headerValue);
                    if (i != 8) continue;
                    String componentSeparator = new String(hl7MessageBytes, 4, 1, charset);
                    String[] components = headerValue.split(String.format("\\Q%s\\E", componentSeparator), 3);
                    message.setHeader("CamelMllpEventType", (Object)components[0]);
                    if (2 > components.length) continue;
                    message.setHeader("CamelMllpTriggerEvent", (Object)components[1]);
                }
            } else {
                MllpTcpServerConsumer.this.log.trace("HL7 Message headers disabled");
            }
        }

        @Override
        public void interrupt() {
            if (null != this.clientSocket && this.clientSocket.isConnected() && !this.clientSocket.isClosed()) {
                MllpSocketUtil.close(this.clientSocket, MllpTcpServerConsumer.this.log, this.getClass().getSimpleName() + " interrupted");
            }
            super.interrupt();
        }
    }

    class ServerSocketThread
    extends Thread {
        ServerSocket serverSocket;

        ServerSocketThread(ServerSocket serverSocket) {
            this.setName(this.createThreadName(serverSocket));
            this.serverSocket = serverSocket;
        }

        String createThreadName(ServerSocket serverSocket) {
            String fullClassName = this.getClass().getName();
            String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
            String fullEndpointKey = MllpTcpServerConsumer.this.endpoint.getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            return String.format("%s[%s] - %s", className, endpointKey, serverSocket.getLocalSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            MDC.put((String)"camel.contextId", (String)MllpTcpServerConsumer.this.endpoint.getCamelContext().getName());
            try {
                while (!this.isInterrupted() && null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                    Socket socket = null;
                    try {
                        socket = this.serverSocket.accept();
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        MllpTcpServerConsumer.this.log.debug("Timeout waiting for client connection - keep listening");
                        continue;
                    }
                    catch (SocketException socketEx) {
                        if (!this.serverSocket.isBound()) continue;
                        try {
                            this.serverSocket.close();
                            continue;
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after SocketException on accept() - ignoring", (Throwable)ex);
                            continue;
                        }
                    }
                    catch (IOException ioEx) {
                        MllpTcpServerConsumer.this.log.error("Exception encountered accepting connection - closing ServerSocket", (Throwable)ioEx);
                        if (!this.serverSocket.isBound()) continue;
                        try {
                            this.serverSocket.close();
                            continue;
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after exception on accept() - ignoring", (Throwable)ex);
                            continue;
                        }
                    }
                    try {
                        InputStream inputStream;
                        if (!socket.isConnected() || socket.isClosed()) continue;
                        MllpTcpServerConsumer.this.log.debug("Socket appears to be there - checking for available data in {} milliseconds", (Object)100);
                        Thread.sleep(100L);
                        try {
                            inputStream = socket.getInputStream();
                        }
                        catch (IOException ioEx) {
                            MllpSocketUtil.reset(socket, MllpTcpServerConsumer.this.log, "Failed to retrieve the InputStream for socket after the initial connection was accepted");
                            continue;
                        }
                        if (0 < inputStream.available()) {
                            ClientSocketThread clientThread = new ClientSocketThread(socket, null);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                            clientThread.start();
                            continue;
                        }
                        MllpSocketUtil.setSoTimeout(socket, 250, MllpTcpServerConsumer.this.log, "Preparing to check for available data on component startup");
                        try {
                            int tmpByte = inputStream.read();
                            if (-1 == tmpByte) {
                                MllpTcpServerConsumer.this.log.debug("Check for available data failed - Socket.read() returned END_OF_STREAM");
                                MllpSocketUtil.close(socket, null, null);
                                continue;
                            }
                            ClientSocketThread clientThread = new ClientSocketThread(socket, tmpByte);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                            clientThread.start();
                        }
                        catch (SocketTimeoutException timeoutEx) {
                            String logMessageFormat = "Check for available data failed - Socket.read() timed-out after {} milliseconds.  No Data - but the socket is there.  Starting ClientSocketThread";
                            MllpTcpServerConsumer.this.log.debug(logMessageFormat, (Object)250);
                            ClientSocketThread clientThread = new ClientSocketThread(socket, null);
                            MllpTcpServerConsumer.this.clientThreads.add(clientThread);
                            clientThread.start();
                        }
                        catch (IOException ioEx) {
                            MllpTcpServerConsumer.this.log.debug("Ignoring IOException encountered when attempting to read a byte - connection was reset");
                            try {
                                socket.close();
                            }
                            catch (IOException closeEx) {
                                MllpTcpServerConsumer.this.log.debug("Ignoring IOException encountered when attempting to close the connection after the connection reset was detected", (Throwable)closeEx);
                            }
                        }
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        MllpTcpServerConsumer.this.log.trace("SocketTimeoutException waiting for new connections - no new connections");
                        for (int i = MllpTcpServerConsumer.this.clientThreads.size() - 1; i >= 0; --i) {
                            ClientSocketThread thread = MllpTcpServerConsumer.this.clientThreads.get(i);
                            if (thread.isAlive()) continue;
                            MllpTcpServerConsumer.this.clientThreads.remove(i);
                        }
                    }
                    catch (InterruptedException interruptEx) {
                        MllpTcpServerConsumer.this.log.debug("accept loop interrupted - closing ServerSocket");
                        try {
                            this.serverSocket.close();
                        }
                        catch (Exception ex) {
                            MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after InterruptedException - ignoring", (Throwable)ex);
                        }
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.error("Exception accepting new connection - retrying", (Throwable)ex);
                    }
                }
                return;
            }
            finally {
                MllpTcpServerConsumer.this.log.debug("ServerSocket.accept loop finished - closing listener");
                if (null != this.serverSocket && this.serverSocket.isBound() && !this.serverSocket.isClosed()) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception ex) {
                        MllpTcpServerConsumer.this.log.debug("Exception encountered closing ServerSocket after accept loop had exited - ignoring", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            if (null != this.serverSocket && this.serverSocket.isBound()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioEx) {
                    MllpTcpServerConsumer.this.log.warn("Exception encountered closing ServerSocket in interrupt() method - ignoring", (Throwable)ioEx);
                }
            }
        }
    }
}

