/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.infinispan.InfinispanCustomListener;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.context.Flag;

@UriParams
public class InfinispanConfiguration {
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriParam
    private BasicCacheContainer cacheContainer;
    @UriParam
    private String cacheName;
    @UriParam(label="producer", defaultValue="put", enums="put,putAll,putIfAbsent,putAsync,putAllAsync,putIfAbsentAsync,get,containsKey,containsValue,remove,removeAsync,replace,replaceAsync,size,clear,clearAsync,query,stats")
    private String command;
    @UriParam(label="consumer", defaultValue="true")
    private boolean sync = true;
    @UriParam(label="consumer", javaType="java.lang.String")
    private Set<String> eventTypes;
    @UriParam(label="consumer")
    private InfinispanCustomListener customListener;
    @UriParam(label="consumer", defaultValue="false")
    private boolean clusteredListener;
    @UriParam
    private InfinispanQueryBuilder queryBuilder;
    @UriParam(label="advanced", javaType="java.lang.String")
    private Flag[] flags;
    @UriParam(label="advanced")
    private String configurationUri;

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean hasCommand() {
        return ObjectHelper.isNotEmpty((Object)this.command);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public BasicCacheContainer getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(BasicCacheContainer cacheContainer) {
        this.cacheContainer = cacheContainer;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isClusteredListener() {
        return this.clusteredListener;
    }

    public void setClusteredListener(boolean clusteredListener) {
        this.clusteredListener = clusteredListener;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(Set<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void setEventTypes(String eventTypes) {
        this.eventTypes = new HashSet<String>(Arrays.asList(eventTypes.split(",")));
    }

    public InfinispanCustomListener getCustomListener() {
        return this.customListener;
    }

    public void setCustomListener(InfinispanCustomListener customListener) {
        this.customListener = customListener;
    }

    public boolean hasCustomListener() {
        return this.customListener != null;
    }

    public InfinispanQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(InfinispanQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public boolean hasQueryBuilder() {
        return this.queryBuilder != null;
    }

    public Flag[] getFlags() {
        return this.flags;
    }

    public void setFlags(String flagsAsString) {
        String[] flagsArray = flagsAsString.split(",");
        this.flags = new Flag[flagsArray.length];
        for (int i = 0; i < flagsArray.length; ++i) {
            this.flags[i] = Flag.valueOf((String)flagsArray[i]);
        }
    }

    public void setFlags(Flag ... flags) {
        this.flags = flags;
    }

    public boolean hasFlags() {
        return this.flags != null && this.flags.length > 0;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }
}

