/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.rabbitmq.RabbitConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class RabbitMQConsumer
extends DefaultConsumer
implements Suspendable {
    private ExecutorService executor;
    private Connection conn;
    private int closeTimeout = 30000;
    private final RabbitMQEndpoint endpoint;
    private StartConsumerCallable startConsumerCallable;
    private final List<RabbitConsumer> consumers = new ArrayList<RabbitConsumer>();

    public RabbitMQConsumer(RabbitMQEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public RabbitMQEndpoint getEndpoint() {
        return (RabbitMQEndpoint)super.getEndpoint();
    }

    private void openConnection() throws IOException, TimeoutException {
        this.log.trace("Creating connection...");
        this.conn = this.getEndpoint().connect(this.executor);
        this.log.debug("Created connection: {}", (Object)this.conn);
    }

    protected synchronized Connection getConnection() throws IOException, TimeoutException {
        if (this.conn != null && this.conn.isOpen()) {
            return this.conn;
        }
        this.log.debug("The existing connection is closed");
        this.openConnection();
        return this.conn;
    }

    private void startConsumers() throws IOException {
        for (int i = 0; i < this.endpoint.getConcurrentConsumers(); ++i) {
            this.createConsumer();
        }
        try {
            for (RabbitConsumer consumer : this.consumers) {
                consumer.start();
            }
        }
        catch (Exception e) {
            this.log.info("Connection failed, will start background thread to retry!", (Throwable)e);
            this.reconnect();
        }
    }

    private void createConsumer() throws IOException {
        RabbitConsumer consumer = new RabbitConsumer(this);
        this.consumers.add(consumer);
    }

    private synchronized void reconnect() {
        if (this.startConsumerCallable != null) {
            return;
        }
        Integer networkRecoveryInterval = this.getEndpoint().getNetworkRecoveryInterval();
        long connectionRetryInterval = networkRecoveryInterval != null && networkRecoveryInterval > 0 ? (long)networkRecoveryInterval.intValue() : 100L;
        this.startConsumerCallable = new StartConsumerCallable(connectionRetryInterval);
        this.executor.submit(this.startConsumerCallable);
    }

    private void closeConnectionAndChannel() throws IOException, TimeoutException {
        if (this.startConsumerCallable != null) {
            this.startConsumerCallable.stop();
        }
        for (RabbitConsumer consumer : this.consumers) {
            try {
                consumer.stop();
            }
            catch (TimeoutException e) {
                this.log.warn("Timeout occurred while stopping consumer. This exception is ignored", (Throwable)e);
            }
        }
        this.consumers.clear();
        if (this.conn != null) {
            this.log.debug("Closing connection: {} with timeout: {} ms.", (Object)this.conn, (Object)this.closeTimeout);
            this.conn.close(this.closeTimeout);
            this.conn = null;
        }
    }

    protected void doSuspend() throws Exception {
        this.closeConnectionAndChannel();
    }

    protected void doResume() throws Exception {
        this.reconnect();
    }

    protected void doStart() throws Exception {
        this.executor = this.endpoint.createExecutor();
        this.log.debug("Using executor {}", (Object)this.executor);
        this.startConsumers();
    }

    protected void doStop() throws Exception {
        this.closeConnectionAndChannel();
        if (this.executor != null) {
            if (this.endpoint != null && this.endpoint.getCamelContext() != null) {
                this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
            this.executor = null;
        }
    }

    private class StartConsumerCallable
    implements Callable<Void> {
        private final long connectionRetryInterval;
        private final AtomicBoolean running = new AtomicBoolean(true);

        StartConsumerCallable(long connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public void stop() {
            this.running.set(false);
            RabbitMQConsumer.this.startConsumerCallable = null;
        }

        @Override
        public Void call() throws Exception {
            boolean connectionFailed = true;
            while (this.running.get() && connectionFailed) {
                try {
                    for (RabbitConsumer consumer : RabbitMQConsumer.this.consumers) {
                        consumer.reconnect();
                    }
                    connectionFailed = false;
                }
                catch (Exception e) {
                    RabbitMQConsumer.this.log.info("Connection failed, will retry in " + this.connectionRetryInterval + "ms", (Throwable)e);
                    Thread.sleep(this.connectionRetryInterval);
                }
            }
            if (!connectionFailed) {
                RabbitMQConsumer.this.startConsumers();
            }
            this.stop();
            return null;
        }
    }
}

