/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.timeline;

import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.timeline.AbstractStatusConsumer;
import twitter4j.Paging;
import twitter4j.Status;
import twitter4j.TwitterException;

public class UserConsumer
extends AbstractStatusConsumer {
    public UserConsumer(TwitterEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected List<Status> doPoll() throws TwitterException {
        Paging paging = this.getLastIdPaging();
        String user = this.endpoint.getProperties().getUser();
        this.log.trace("doPoll.getUserTimeline(user={}, sinceId={})", (Object)user, (Object)paging.getSinceId());
        return this.getTwitter().getUserTimeline(user, paging);
    }

    @Override
    protected List<Status> doDirect() throws TwitterException {
        String user = this.endpoint.getProperties().getUser();
        this.log.trace("doDirect.getUserTimeline(user={})", (Object)user);
        return this.getTwitter().getUserTimeline(user);
    }
}

