/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.TwitterEndpointDirect;
import org.apache.camel.component.twitter.TwitterEndpointEvent;
import org.apache.camel.component.twitter.TwitterEndpointPolling;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;

public class TwitterComponent
extends UriEndpointComponent {
    @Metadata(label="security", secret=true)
    private String consumerKey;
    @Metadata(label="security", secret=true)
    private String consumerSecret;
    @Metadata(label="security", secret=true)
    private String accessToken;
    @Metadata(label="security", secret=true)
    private String accessTokenSecret;
    @Metadata(label="proxy")
    private String httpProxyHost;
    @Metadata(label="proxy")
    private String httpProxyUser;
    @Metadata(label="proxy")
    private String httpProxyPassword;
    @Metadata(label="proxy")
    private Integer httpProxyPort;

    public TwitterComponent() {
        super(TwitterEndpointEvent.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TwitterEndpoint endpoint;
        TwitterConfiguration properties = new TwitterConfiguration();
        properties.setConsumerKey(this.consumerKey);
        properties.setConsumerSecret(this.consumerSecret);
        properties.setAccessToken(this.accessToken);
        properties.setAccessTokenSecret(this.accessTokenSecret);
        properties.setHttpProxyHost(this.httpProxyHost);
        properties.setHttpProxyUser(this.httpProxyUser);
        properties.setHttpProxyPassword(this.httpProxyPassword);
        if (this.httpProxyPort != null) {
            properties.setHttpProxyPort(this.httpProxyPort);
        }
        this.setProperties(properties, parameters);
        switch (properties.getType()) {
            case POLLING: {
                endpoint = new TwitterEndpointPolling(uri, this, properties);
                break;
            }
            case EVENT: {
                endpoint = new TwitterEndpointEvent(uri, this, properties);
                break;
            }
            default: {
                endpoint = new TwitterEndpointDirect(uri, this, properties);
            }
        }
        return endpoint;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }
}

