/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.enpoint;

import com.google.common.base.Optional;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.AbstractConsulConsumer;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;

public class ConsulKeyValueConsumer
extends AbstractConsulConsumer<KeyValueClient> {
    public ConsulKeyValueConsumer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Processor processor) {
        super(endpoint, configuration, processor, c -> c.keyValueClient());
    }

    @Override
    protected Runnable createWatcher(KeyValueClient client) throws Exception {
        return this.configuration.isRecursive() ? new RecursivePathWatcher(client) : new PathWatcher(client);
    }

    private class RecursivePathWatcher
    extends AbstractPathWatcher<List<Value>> {
        RecursivePathWatcher(KeyValueClient client) {
            super(client);
        }

        public void watch(KeyValueClient client) {
            client.getValues(ConsulKeyValueConsumer.this.key, this.queryOptions(), (ConsulResponseCallback)this);
        }

        @Override
        public void onResponse(List<Value> values) {
            values.forEach(this::onValue);
        }
    }

    private class PathWatcher
    extends AbstractPathWatcher<Optional<Value>> {
        PathWatcher(KeyValueClient client) {
            super(client);
        }

        public void watch(KeyValueClient client) {
            client.getValue(ConsulKeyValueConsumer.this.key, this.queryOptions(), (ConsulResponseCallback)this);
        }

        @Override
        public void onResponse(Optional<Value> value) {
            if (value.isPresent()) {
                this.onValue((Value)value.get());
            }
        }
    }

    private abstract class AbstractPathWatcher<T>
    extends AbstractConsulConsumer.AbstractWatcher
    implements ConsulResponseCallback<T> {
        protected AbstractPathWatcher(KeyValueClient client) {
            super(ConsulKeyValueConsumer.this, client);
        }

        protected QueryOptions queryOptions() {
            return QueryOptions.blockSeconds((int)ConsulKeyValueConsumer.this.configuration.getBlockSeconds(), (BigInteger)((BigInteger)ConsulKeyValueConsumer.this.index.get())).build();
        }

        public void onComplete(ConsulResponse<T> consulResponse) {
            if (ConsulKeyValueConsumer.this.isRunAllowed()) {
                this.onResponse(consulResponse.getResponse());
                this.setIndex(consulResponse.getIndex());
                this.watch();
            }
        }

        public void onFailure(Throwable throwable) {
            this.onError(throwable);
        }

        protected void onValue(Value value) {
            Exchange exchange = ConsulKeyValueConsumer.this.endpoint.createExchange();
            Message message = exchange.getIn();
            message.setHeader("CamelConsulKey", (Object)value.getKey());
            message.setHeader("CamelConsulResult", (Object)true);
            message.setHeader("CamelConsulFlags", (Object)value.getFlags());
            message.setHeader("CamelConsulCreateIndex", (Object)value.getCreateIndex());
            message.setHeader("CamelConsulLockIndex", (Object)value.getLockIndex());
            message.setHeader("CamelConsulModifyIndex", (Object)value.getModifyIndex());
            if (value.getSession().isPresent()) {
                message.setHeader("CamelConsulSession", value.getSession().get());
            }
            message.setBody(ConsulKeyValueConsumer.this.configuration.isValueAsString() ? value.getValueAsString().orNull() : value.getValue().orNull());
            try {
                ConsulKeyValueConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                ConsulKeyValueConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }

        protected abstract void onResponse(T var1);
    }
}

