/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsHeaderFilterStrategy;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;

public class SjmsComponent
extends UriEndpointComponent
implements HeaderFilterStrategyAware {
    private ConnectionFactory connectionFactory;
    private ConnectionResource connectionResource;
    private HeaderFilterStrategy headerFilterStrategy = new SjmsHeaderFilterStrategy();
    private JmsKeyFormatStrategy jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
    private Integer connectionCount = 1;
    private TransactionCommitStrategy transactionCommitStrategy;
    private TimedTaskManager timedTaskManager;
    private DestinationCreationStrategy destinationCreationStrategy;
    private ExecutorService asyncStartStopExecutorService;
    private MessageCreatedStrategy messageCreatedStrategy;

    public SjmsComponent() {
        super(SjmsEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SjmsComponent.validateMepAndReplyTo(parameters);
        SjmsEndpoint endpoint = new SjmsEndpoint(uri, (Component)this, remaining);
        this.setProperties((Object)endpoint, parameters);
        if (endpoint.isTransacted()) {
            endpoint.setSynchronous(true);
        }
        if (this.transactionCommitStrategy != null) {
            endpoint.setTransactionCommitStrategy(this.transactionCommitStrategy);
        }
        if (this.destinationCreationStrategy != null) {
            endpoint.setDestinationCreationStrategy(this.destinationCreationStrategy);
        }
        if (this.headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(this.headerFilterStrategy);
        }
        if (this.messageCreatedStrategy != null) {
            endpoint.setMessageCreatedStrategy(this.messageCreatedStrategy);
        }
        return endpoint;
    }

    private static void validateMepAndReplyTo(Map<String, Object> parameters) throws Exception {
        boolean namedReplyToSet = parameters.containsKey("namedReplyTo");
        boolean mepSet = parameters.containsKey("exchangePattern");
        if (namedReplyToSet && mepSet && !parameters.get("exchangePattern").equals(ExchangePattern.InOut.toString())) {
            String namedReplyTo = (String)parameters.get("namedReplyTo");
            ExchangePattern mep = ExchangePattern.valueOf((String)((String)parameters.get("exchangePattern")));
            throw new CamelException("Setting parameter namedReplyTo=" + namedReplyTo + " requires a MEP of type InOut. Parameter exchangePattern is set to " + mep);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.timedTaskManager = new TimedTaskManager();
    }

    protected void doStop() throws Exception {
        if (this.timedTaskManager != null) {
            this.timedTaskManager.cancelTasks();
            this.timedTaskManager = null;
        }
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        if (this.asyncStartStopExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.asyncStartStopExecutorService);
            this.asyncStartStopExecutorService = null;
        }
        super.doShutdown();
    }

    protected synchronized ExecutorService getAsyncStartStopExecutorService() {
        if (this.asyncStartStopExecutorService == null) {
            this.asyncStartStopExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AsyncStartStopListener");
        }
        return this.asyncStartStopExecutorService;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public ConnectionResource getConnectionResource() {
        return this.connectionResource;
    }

    public void setConnectionCount(Integer maxConnections) {
        this.connectionCount = maxConnections;
    }

    public Integer getConnectionCount() {
        return this.connectionCount;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.jmsKeyFormatStrategy;
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy commitStrategy) {
        this.transactionCommitStrategy = commitStrategy;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public TimedTaskManager getTimedTaskManager() {
        return this.timedTaskManager;
    }

    public void setTimedTaskManager(TimedTaskManager timedTaskManager) {
        this.timedTaskManager = timedTaskManager;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }
}

