/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcache;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jcache.JCacheComponent;
import org.apache.camel.component.jcache.JCacheConfiguration;
import org.apache.camel.component.jcache.JCacheConsumer;
import org.apache.camel.component.jcache.JCacheHelper;
import org.apache.camel.component.jcache.JCacheManager;
import org.apache.camel.component.jcache.JCacheProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="jcache", title="JCache", syntax="jcache:cacheName", consumerClass=JCacheConsumer.class, label="cache,datagrid,clustering")
public class JCacheEndpoint
extends DefaultEndpoint {
    @UriPath(description="the cache name")
    @Metadata(required="true")
    private final String cacheName;
    @UriParam
    private final JCacheConfiguration cacheConfiguration;
    private final JCacheManager<Object, Object> cacheManager;

    public JCacheEndpoint(String uri, JCacheComponent component, JCacheConfiguration configuration) {
        super(uri, (Component)component);
        this.cacheName = configuration.getCacheName();
        this.cacheConfiguration = configuration;
        this.cacheManager = JCacheHelper.createManager(configuration);
    }

    public Producer createProducer() throws Exception {
        return new JCacheProducer(this, this.cacheConfiguration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new JCacheConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStop() throws Exception {
        this.cacheManager.close();
    }

    JCacheManager getManager() {
        return this.cacheManager;
    }
}

