# Welcome to the Apache Camel Examples!

### Introduction

This directory contains the various examples for working with Apache
Camel. The examples can be run using Maven. When using the Maven
command, Maven will attempt to download the required dependencies from a
central repository to your local repository.
View the individual example READMEs for details.

### List of all examples

All examples have been sort by type/category


##### Easy

* [camel-example-cdi](camel-example-cdi/README.md)
* [camel-example-console](camel-example-console/README.md)
* [camel-example-jmx](camel-example-jmx/README.md)
* [camel-example-ftp](camel-example-ftp/README.md)
* [camel-example-ssh](camel-example-ssh/README.md)
* [camel-example-ssh-security](camel-example-ssh-security/README.md)

##### EIP

* [camel-example-widget-gadget-cdi](camel-example-widget-gadget-cdi/README.md)
* [camel-example-widget-gadget-java](camel-example-widget-gadget-java/README.md)
* [camel-example-widget-gadget-xml](camel-example-widget-gadget-xml/README.md)
* [camel-example-tracer](camel-example-tracer/README.md)
* [camel-example-route-throttling](camel-example-route-throttling/README.md)
* [camel-example-aggregate](camel-example-aggregate/README.md)
* [camel-example-etl](camel-example-etl/README.md)
* [camel-example-loadbalancing](camel-example-loadbalancing/README.md)
* [camel-example-hystrix](camel-example-hystrix/README.md)

##### Tutorials

* [camel-example-loan-broker](camel-example-loan-broker/README.md)
* [camel-example-reportincident](camel-example-reportincident/README.md)
* [camel-example-reportincident-wssecurity](camel-example-reportincident-wssecurity/README.md)
* [camel-example-cafe](camel-example-cafe/README.md)

##### CDI

* [camel-example-cdi](camel-example-cdi/README.md)
* [camel-example-cdi-metrics](camel-example-cdi-metrics/README.md)
* [camel-example-cdi-properties](camel-example-cdi-properties/README.md)
* [camel-example-cdi-rest-servlet](camel-example-cdi-rest-servlet/README.md)
* [camel-example-cdi-test](camel-example-cdi-test/README.md)
* [camel-example-cdi-xml](camel-example-cdi-xml/README.md)
* [camel-example-widget-gadget-cdi](camel-example-widget-gadget-cdi/README.md)

##### OSGi

* [camel-example-osgi](camel-example-osgi/README.md)
* [camel-example-osgi-rmi](camel-example-osgi-rmi/README.md)
* [camel-example-sql-blueprint](camel-example-sql-blueprint/README.md)
* [camel-example-servlet-rest-blueprint](camel-example-servlet-rest-blueprint/README.md)

##### Database

* [camel-example-restlet-jdbc](camel-example-restlet-jdbc/README.md)
* [camel-example-mybatis](camel-example-mybatis/README.md)
* [camel-example-jdbc](camel-example-jdbc/README.md)
* [camel-example-restlet-jdbc](camel-example-restlet-jdbc/README.md)
* [camel-example-sql](camel-example-sql/README.md)

##### Messaging 

* [camel-example-activemq-tomcat](camel-example-activemq-tomcat/README.md)
* [camel-example-jms-file](camel-example-jms-file/README.md)
* [camel-example-guice-jms](camel-example-guice-jms/README.md)
* [camel-example-pojo-messaging](camel-example-pojo-messaging/README.md)

##### Social

* [camel-example-box-osgi](camel-example-box-osgi/README.md)
* [camel-example-simplejirabot](camel-example-simplejirabot/README.md)
* [camel-example-twitter-websocket](camel-example-twitter-websocket/README.md)
* [camel-example-twitter-websocket-blueprint](camel-example-twitter-websocket-blueprint/README.md)

##### Spring

* [camel-example-spring](camel-example-spring/README.md)
* [camel-example-spring-boot](camel-example-spring-boot/README.md)
* [camel-example-spring-boot-metrics](camel-example-spring-boot-metrics/README.md)
* [camel-example-spring-boot-rest-sql](camel-example-spring-boot-rest-sql/README.md)
* [camel-example-spring-javaconfig](camel-example-spring-javaconfig/README.md)
* [camel-example-spring-jms](camel-example-spring-jms/README.md)
* [camel-example-spring-security](camel-example-spring-security/README.md)
* [camel-example-spring-ws](camel-example-spring-ws/README.md)
* [camel-example-spring-xquery](camel-example-spring-xquery/README.md)

##### Rest & Swagger

* [camel-example-spark-rest](camel-example-spark-rest/README.md)
* [camel-example-swagger-cdi](camel-example-swagger-cdi/README.md)
* [camel-example-swagger-xml](camel-example-swagger-xml/README.md)

##### Management & Monitoring

* [camel-example-bam](camel-example-bam/README.md)
* [camel-example-management](camel-example-management/README.md)
* [camel-example-splunk](camel-example-splunk/README.md)
* [camel-example-zipkin](camel-example-zipkin/README.md)

##### Miscellaneous

* [camel-example-servlet-tomcat](camel-example-servlet-tomcat/README.md)
* [camel-example-servlet-tomcat-no-spring](camel-example-servlet-tomcat-no-spring/README.md)
* [camel-example-netty-http](camel-example-netty-http/README.md)

##### WebService SOAP

* [camel-example-cxf](camel-example-cxf/README.md)
* [camel-example-cxf-blueprint](camel-example-cxf-blueprint/README.md)
* [camel-example-cxf-osgi](camel-example-cxf-osgi/README.md)
* [camel-example-cxf-proxy](camel-example-cxf-proxy/README.md)
* [camel-example-cxf-tomcat](camel-example-cxf-tomcat/README.md)

### Documentation

They are described in detail here <http://camel.apache.org/examples.html>

Before you start we recommend you install a recent distribution of Maven, which we use to run our examples <http://maven.apache.org/>

### Forum, Help, etc

If you hit an problems please let us know on the Camel Forums <http://camel.apache.org/discussion-forums.html>

Please help us make Apache Camel better - we appreciate any feedback you may
have.  Enjoy!

The Camel riders!
