/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.kafka.springboot;

import java.util.concurrent.ExecutorService;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The kafka component allows messages to be sent to (or consumed from) Apache
 * Kafka brokers.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.kafka")
public class KafkaComponentConfiguration {

    /**
     * To use a shared custom worker pool for continue routing Exchange after
     * kafka server has acknowledge the message that was sent to it from
     * KafkaProducer using asynchronous non-blocking processing. If using this
     * option then you must handle the lifecycle of the thread pool to shut the
     * pool down when no longer needed.
     */
    private ExecutorService workerPool;

    public ExecutorService getWorkerPool() {
        return workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }
}