/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import com.google.gdata.util.common.util.Base64;
import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.camel.CamelContext;
import org.apache.camel.component.gae.auth.GAuthKeyLoader;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public class GAuthPk8Loader
implements GAuthKeyLoader {
    private static final String BEGIN = "-----BEGIN PRIVATE KEY-----";
    private static final String END = "-----END PRIVATE KEY-----";
    private CamelContext camelContext;
    private String keyLocation;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setKeyLocation(String keyLocation) {
        this.keyLocation = keyLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey loadPrivateKey() throws Exception {
        String str;
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.keyLocation);
        try {
            str = (String)this.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        if (!System.lineSeparator().equals("\n")) {
            str = str.replaceAll(System.lineSeparator(), "\n");
        }
        if (str.contains(BEGIN) && str.contains(END)) {
            str = str.substring(BEGIN.length(), str.lastIndexOf(END));
        }
        byte[] decoded = Base64.decode((String)str);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePrivate(new PKCS8EncodedKeySpec(decoded));
    }
}

