/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import org.apache.camel.CamelContext;
import org.apache.camel.component.gae.auth.GAuthKeyLoader;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public class GAuthJksLoader
implements GAuthKeyLoader {
    private CamelContext camelContext;
    private String keyStoreLocation;
    private String storePass;
    private String keyPass;
    private String keyAlias;

    public GAuthJksLoader() {
        this(null, null, null, null);
    }

    public GAuthJksLoader(String keyStoreLocation, String storePass, String keyPass, String keyAlias) {
        this.keyStoreLocation = keyStoreLocation;
        this.storePass = storePass;
        this.keyPass = keyPass;
        this.keyAlias = keyAlias;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public void setStorePass(String storePass) {
        this.storePass = storePass;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrivateKey loadPrivateKey() throws Exception {
        InputStream input = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.keyStoreLocation);
        try {
            PrivateKey privateKey = this.loadPrivateKey(input);
            return privateKey;
        }
        finally {
            IOHelper.close((Closeable)input);
        }
    }

    private PrivateKey loadPrivateKey(InputStream input) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(input, this.storePass.toCharArray());
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keystore.getEntry(this.keyAlias, new KeyStore.PasswordProtection(this.keyPass.toCharArray()));
        return entry.getPrivateKey();
    }
}

