/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cmis.CMISComponent;
import org.apache.camel.component.cmis.CMISConsumer;
import org.apache.camel.component.cmis.CMISProducer;
import org.apache.camel.component.cmis.CMISQueryProducer;
import org.apache.camel.component.cmis.CMISSessionFacadeFactory;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="cmis", title="CMIS", syntax="cmis:url", consumerClass=CMISConsumer.class, label="cms,database")
public class CMISEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CMISEndpoint.class);
    private final CMISSessionFacadeFactory sessionFacadeFactory;
    @UriPath(description="the cmis url")
    @Metadata(required="true")
    private final String url;
    @UriParam(label="producer")
    private boolean queryMode;

    public CMISEndpoint(String uri, CMISComponent cmisComponent, CMISSessionFacadeFactory sessionFacadeFactory) {
        super(uri, (Component)cmisComponent);
        this.url = uri;
        this.sessionFacadeFactory = sessionFacadeFactory;
    }

    public Producer createProducer() throws Exception {
        return this.queryMode ? new CMISQueryProducer(this, this.sessionFacadeFactory) : new CMISProducer(this, this.sessionFacadeFactory);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CMISConsumer consumer = new CMISConsumer(this, processor, this.sessionFacadeFactory);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean queryMode) {
        this.queryMode = queryMode;
    }
}

