/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometdBinding {
    public static final String HEADERS_FIELD = "CamelHeaders";
    public static final String COMETD_CLIENT_ID_HEADER_NAME = "CometdClientId";
    public static final String COMETD_SUBSCRIPTION_HEADER_NAME = "subscription";
    public static final String COMETD_SESSION_ATTR_HEADER_NAME = "CometdSessionAttr";
    private static final String IMPROPER_SESSTION_ATTRIBUTE_TYPE_MESSAGE = "Sesstion attribute %s has a value of %s which cannot be included as at header because it is not an int, string, or long.";
    private static final Logger LOG = LoggerFactory.getLogger(CometdBinding.class);
    private final BayeuxServerImpl bayeux;
    private boolean enableSessionHeader;

    public CometdBinding(BayeuxServerImpl bayeux) {
        this(bayeux, false);
    }

    public CometdBinding(BayeuxServerImpl bayeux, boolean enableSessionHeader) {
        this.bayeux = bayeux;
        this.enableSessionHeader = enableSessionHeader;
    }

    public ServerMessage.Mutable createCometdMessage(ServerChannel channel, ServerSession serverSession, Message camelMessage) {
        ServerMessage.Mutable mutable = this.bayeux.newMessage();
        mutable.setChannel(channel.getId());
        if (serverSession != null) {
            mutable.setClientId(serverSession.getId());
        }
        this.addHeadersToMessage(mutable, camelMessage);
        mutable.setData(camelMessage.getBody());
        return mutable;
    }

    public Message createCamelMessage(ServerSession remote, ServerMessage cometdMessage, Object data) {
        if (cometdMessage != null) {
            data = cometdMessage.getData();
        }
        DefaultMessage message = new DefaultMessage();
        message.setBody(data);
        Map<String, Object> headers = this.getHeadersFromMessage(cometdMessage);
        if (headers != null) {
            message.setHeaders(headers);
        }
        message.setHeader(COMETD_CLIENT_ID_HEADER_NAME, (Object)remote.getId());
        if (cometdMessage != null && cometdMessage.get((Object)COMETD_SUBSCRIPTION_HEADER_NAME) != null) {
            message.setHeader(COMETD_SUBSCRIPTION_HEADER_NAME, cometdMessage.get((Object)COMETD_SUBSCRIPTION_HEADER_NAME));
        }
        if (this.enableSessionHeader) {
            this.addSessionAttributesToMessageHeaders(remote, (Message)message);
        }
        return message;
    }

    private void addSessionAttributesToMessageHeaders(ServerSession remote, Message message) {
        Set attributeNames = remote.getAttributeNames();
        for (String attributeName : attributeNames) {
            Object attribute = remote.getAttribute(attributeName);
            if (attribute instanceof Integer || attribute instanceof String || attribute instanceof Long || attribute instanceof Double || attribute instanceof Boolean) {
                message.setHeader(attributeName, attribute);
                continue;
            }
            LOG.info(String.format(IMPROPER_SESSTION_ATTRIBUTE_TYPE_MESSAGE, attributeName, attribute));
        }
    }

    public void addHeadersToMessage(ServerMessage.Mutable cometdMessage, Message camelMessage) {
        if (camelMessage.hasHeaders()) {
            Map ext = cometdMessage.getExt(true);
            ext.put(HEADERS_FIELD, this.filterHeaders(camelMessage.getHeaders()));
        }
    }

    private Object filterHeaders(Map<String, Object> headers) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (entry == null || entry.getKey() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private Map<String, Object> getHeadersFromMessage(ServerMessage message) {
        Map ext = message.getExt();
        if (ext != null && ext.containsKey(HEADERS_FIELD)) {
            return (Map)ext.get(HEADERS_FIELD);
        }
        return null;
    }
}

