/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.cdi.CdiEventConsumer;
import org.apache.camel.cdi.CdiEventProducer;
import org.apache.camel.cdi.ForwardingObserverMethod;
import org.apache.camel.impl.DefaultEndpoint;

public final class CdiEventEndpoint<T>
extends DefaultEndpoint {
    private final List<CdiEventConsumer<T>> consumers = new ArrayList<CdiEventConsumer<T>>();
    private final Event<T> event;

    CdiEventEndpoint(Event<T> event, String endpointUri, CamelContext context, ForwardingObserverMethod<T> observer) {
        super(endpointUri, context);
        this.event = event;
        observer.setObserver(this);
    }

    public Consumer createConsumer(Processor processor) {
        return new CdiEventConsumer(this, processor);
    }

    public Producer createProducer() {
        return new CdiEventProducer<T>(this, this.event);
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConsumer(CdiEventConsumer<T> consumer) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            this.consumers.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterConsumer(CdiEventConsumer<T> consumer) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            this.consumers.remove(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(T t) {
        List<CdiEventConsumer<T>> list = this.consumers;
        synchronized (list) {
            for (CdiEventConsumer<T> consumer : this.consumers) {
                consumer.notify(t);
            }
        }
    }
}

