/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.rx.CamelOperator;
import org.apache.camel.rx.RuntimeCamelRxException;
import org.apache.camel.rx.support.EndpointObservable;
import org.apache.camel.rx.support.EndpointSubscribeFunc;
import org.apache.camel.rx.support.ExchangeToBodyFunc1;
import org.apache.camel.rx.support.ObserverSender;
import org.apache.camel.util.CamelContextHelper;
import rx.Observable;
import rx.functions.Func1;

public class ReactiveCamel {
    private final CamelContext camelContext;
    private final ExecutorService workerPool;

    public ReactiveCamel(CamelContext camelContext) {
        this(camelContext, 10);
    }

    public ReactiveCamel(CamelContext camelContext, int maxWorkerPoolSize) {
        this.camelContext = camelContext;
        this.workerPool = camelContext.getExecutorServiceManager().newThreadPool((Object)this, "ReactiveCamelWorker", 0, maxWorkerPoolSize);
    }

    public Observable<Message> toObservable(String uri) {
        return this.toObservable(this.endpoint(uri));
    }

    public <T> Observable<T> toObservable(String uri, Class<T> bodyType) {
        return this.toObservable(this.endpoint(uri), bodyType);
    }

    public Observable<Message> toObservable(Endpoint endpoint) {
        return this.toObservable(endpoint, Message.class);
    }

    public <T> Observable<T> toObservable(Endpoint endpoint, Class<T> bodyType) {
        return this.createEndpointObservable(endpoint, new ExchangeToBodyFunc1<T>(bodyType));
    }

    public <T> void sendTo(Observable<T> observable, String endpointUri) {
        this.sendTo(observable, this.endpoint(endpointUri));
    }

    public <T> void sendTo(Observable<T> observable, Endpoint endpoint) {
        try {
            ObserverSender observer = new ObserverSender(endpoint);
            observable.subscribe(observer);
        }
        catch (Exception e) {
            throw new RuntimeCamelRxException(e);
        }
    }

    public Observable<Exchange> from(Endpoint endpoint) {
        return this.createEndpointObservable(endpoint);
    }

    public Observable<Exchange> from(String uri) {
        return this.from(this.endpoint(uri));
    }

    public CamelOperator to(String uri) throws Exception {
        return new CamelOperator(this.camelContext, uri);
    }

    public CamelOperator to(Endpoint endpoint) throws Exception {
        return new CamelOperator(endpoint);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Endpoint endpoint(String endpointUri) {
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)this.camelContext, (String)endpointUri);
    }

    protected <T> Observable<T> createEndpointObservable(Endpoint endpoint, Func1<Exchange, T> converter) {
        EndpointSubscribeFunc<T> func = new EndpointSubscribeFunc<T>(this.workerPool, endpoint, converter);
        return new EndpointObservable<T>(endpoint, func);
    }

    protected Observable<Exchange> createEndpointObservable(Endpoint endpoint) {
        return new EndpointObservable<Exchange>(endpoint, new EndpointSubscribeFunc<Exchange>(this.workerPool, endpoint, new Func1<Exchange, Exchange>(){

            public Exchange call(Exchange exchange) {
                return exchange;
            }
        }));
    }
}

