/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import com.mongodb.util.JSON;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.gridfs.GridFsEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class GridFsProducer
extends DefaultProducer {
    private GridFsEndpoint endpoint;

    public GridFsProducer(GridFsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Exchange exchange) throws Exception {
        String operation = this.endpoint.getOperation();
        if (operation == null) {
            operation = (String)exchange.getIn().getHeader("gridfs.operation", String.class);
        }
        if (operation == null || "create".equals(operation)) {
            String ct;
            String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
            Long chunkSize = (Long)exchange.getIn().getHeader("gridfs.chunksize", Long.class);
            InputStream ins = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            GridFSInputFile gfsFile = this.endpoint.getGridFs().createFile(ins, filename, true);
            if (chunkSize != null && chunkSize > 0L) {
                gfsFile.setChunkSize(chunkSize.longValue());
            }
            if ((ct = (String)exchange.getIn().getHeader("Content-Type", String.class)) != null) {
                gfsFile.setContentType(ct);
            }
            String metaData = (String)exchange.getIn().getHeader("gridfs.metadata", String.class);
            DBObject dbObject = (DBObject)JSON.parse((String)metaData);
            gfsFile.setMetaData(dbObject);
            gfsFile.save();
            exchange.getIn().setHeader("CamelFileNameProduced", (Object)gfsFile.getFilename());
            exchange.getIn().setHeader("gridfs.fileid", gfsFile.getId());
            return;
        } else if ("remove".equals(operation)) {
            String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
            this.endpoint.getGridFs().remove(filename);
            return;
        } else if ("findOne".equals(operation)) {
            String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
            GridFSDBFile file = this.endpoint.getGridFs().findOne(filename);
            if (file == null) throw new FileNotFoundException("No GridFS file for " + filename);
            exchange.getIn().setHeader("gridfs.metadata", (Object)JSON.serialize((Object)file.getMetaData()));
            exchange.getIn().setHeader("CamelFileContentType", (Object)file.getContentType());
            exchange.getIn().setHeader("CamelFileLength", (Object)file.getLength());
            exchange.getIn().setHeader("CamelFileLastModified", (Object)file.getUploadDate());
            exchange.getIn().setBody((Object)file.getInputStream(), InputStream.class);
            return;
        } else if ("listAll".equals(operation)) {
            String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
            DBCursor cursor = filename == null ? this.endpoint.getGridFs().getFileList() : this.endpoint.getGridFs().getFileList((DBObject)new BasicDBObject("filename", (Object)filename));
            exchange.getIn().setBody((Object)new DBCursorFilenameReader(cursor), Reader.class);
            return;
        } else {
            if (!"count".equals(operation)) return;
            String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
            DBCursor cursor = filename == null ? this.endpoint.getGridFs().getFileList() : this.endpoint.getGridFs().getFileList((DBObject)new BasicDBObject("filename", (Object)filename));
            exchange.getIn().setBody((Object)cursor.count(), Integer.class);
        }
    }

    private class DBCursorFilenameReader
    extends Reader {
        DBCursor cursor;
        StringBuilder current;
        int pos;

        DBCursorFilenameReader(DBCursor c) {
            this.cursor = c;
            this.current = new StringBuilder(4096);
            this.pos = 0;
            this.fill();
        }

        void fill() {
            if (this.pos > 0) {
                this.current.delete(0, this.pos);
                this.pos = 0;
            }
            while (this.cursor.hasNext() && this.current.length() < 4000) {
                DBObject o = this.cursor.next();
                this.current.append(o.get("filename")).append("\t").append(o.get("_id")).append("\n");
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.pos == this.current.length()) {
                this.fill();
            }
            if (this.pos == this.current.length()) {
                return -1;
            }
            if (len > this.current.length() - this.pos) {
                len = this.current.length() - this.pos;
            }
            this.current.getChars(this.pos, this.pos + len, cbuf, off);
            this.pos += len;
            return len;
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }
}

