/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanstalk;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.beanstalk.BeanstalkCommand;
import org.apache.camel.component.beanstalk.BeanstalkConsumer;
import org.apache.camel.component.beanstalk.BeanstalkProducer;
import org.apache.camel.component.beanstalk.ConnectionSettings;
import org.apache.camel.component.beanstalk.processors.BuryCommand;
import org.apache.camel.component.beanstalk.processors.DefaultCommand;
import org.apache.camel.component.beanstalk.processors.DeleteCommand;
import org.apache.camel.component.beanstalk.processors.KickCommand;
import org.apache.camel.component.beanstalk.processors.PutCommand;
import org.apache.camel.component.beanstalk.processors.ReleaseCommand;
import org.apache.camel.component.beanstalk.processors.TouchCommand;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="beanstalk", title="Beanstalk", syntax="beanstalk:connectionSettings", consumerClass=BeanstalkConsumer.class, label="messaging")
public class BeanstalkEndpoint
extends ScheduledPollEndpoint {
    final ConnectionSettings conn;
    @UriPath(description="Connection settings host:port/tube")
    private String connectionSettings;
    @UriParam
    private BeanstalkCommand command = BeanstalkCommand.put;
    @UriParam(defaultValue="1000")
    private long jobPriority = 1000L;
    @UriParam(defaultValue="0")
    private int jobDelay = 0;
    @UriParam(defaultValue="60")
    private int jobTimeToRun = 60;
    @UriParam(label="consumer")
    private BeanstalkCommand onFailure = BeanstalkCommand.bury;
    @UriParam(label="consumer", defaultValue="true")
    private boolean useBlockIO = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean awaitJob = true;

    public BeanstalkEndpoint(String uri, Component component, ConnectionSettings conn, String connectionSettings) {
        super(uri, component);
        this.conn = conn;
        this.connectionSettings = connectionSettings;
    }

    public String getConnectionSettings() {
        return this.connectionSettings;
    }

    public ConnectionSettings getConnection() {
        return this.conn;
    }

    public ConnectionSettings getConn() {
        return this.conn;
    }

    public BeanstalkCommand getCommand() {
        return this.command;
    }

    public void setCommand(BeanstalkCommand command) {
        this.command = command;
    }

    public long getJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(long jobPriority) {
        this.jobPriority = jobPriority;
    }

    public int getJobDelay() {
        return this.jobDelay;
    }

    public void setJobDelay(int jobDelay) {
        this.jobDelay = jobDelay;
    }

    public int getJobTimeToRun() {
        return this.jobTimeToRun;
    }

    public void setJobTimeToRun(int jobTimeToRun) {
        this.jobTimeToRun = jobTimeToRun;
    }

    public BeanstalkCommand getOnFailure() {
        return this.onFailure;
    }

    public void setOnFailure(BeanstalkCommand onFailure) {
        this.onFailure = onFailure;
    }

    public boolean isUseBlockIO() {
        return this.useBlockIO;
    }

    public void setUseBlockIO(boolean useBlockIO) {
        this.useBlockIO = useBlockIO;
    }

    public boolean isAwaitJob() {
        return this.awaitJob;
    }

    public void setAwaitJob(boolean awaitJob) {
        this.awaitJob = awaitJob;
    }

    public Producer createProducer() throws Exception {
        DefaultCommand cmd;
        if ("put".equals(this.command.name())) {
            cmd = new PutCommand(this);
        } else if ("release".equals(this.command.name())) {
            cmd = new ReleaseCommand(this);
        } else if ("bury".equals(this.command.name())) {
            cmd = new BuryCommand(this);
        } else if ("touch".equals(this.command.name())) {
            cmd = new TouchCommand(this);
        } else if ("delete".equals(this.command.name())) {
            cmd = new DeleteCommand(this);
        } else if ("kick".equals(this.command.name())) {
            cmd = new KickCommand(this);
        } else {
            throw new IllegalArgumentException(String.format("Unknown command for Beanstalk endpoint: %s", new Object[]{this.command}));
        }
        return new BeanstalkProducer(this, cmd);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        BeanstalkConsumer consumer = new BeanstalkConsumer(this, processor);
        consumer.setAwaitJob(this.isAwaitJob());
        consumer.setOnFailure(this.getOnFailure());
        consumer.setUseBlockIO(this.isUseBlockIO());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }
}

