/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.EditableReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersProducer.class);

    public KubernetesReplicationControllersProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listReplicationControllers": {
                this.doList(exchange, operation);
                break;
            }
            case "listReplicationControllersByLabels": {
                this.doListReplicationControllersByLabels(exchange, operation);
                break;
            }
            case "getReplicationController": {
                this.doGetReplicationController(exchange, operation);
                break;
            }
            case "createReplicationController": {
                this.doCreateReplicationController(exchange, operation);
                break;
            }
            case "deleteReplicationController": {
                this.doDeleteReplicationController(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        ReplicationControllerList rcList = null;
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        rcList = !ObjectHelper.isEmpty((Object)namespaceName) ? (ReplicationControllerList)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).list() : (ReplicationControllerList)this.getEndpoint().getKubernetesClient().replicationControllers().list();
        exchange.getOut().setBody((Object)rcList.getItems());
    }

    protected void doListReplicationControllersByLabels(Exchange exchange, String operation) throws Exception {
        ReplicationControllerList rcList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            ClientNonNamespaceOperation replicationControllers = (ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                replicationControllers.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            rcList = (ReplicationControllerList)replicationControllers.list();
        } else {
            ClientMixedOperation replicationControllers = this.getEndpoint().getKubernetesClient().replicationControllers();
            for (Map.Entry entry : labels.entrySet()) {
                replicationControllers.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            rcList = (ReplicationControllerList)replicationControllers.list();
        }
        exchange.getOut().setBody((Object)rcList.getItems());
    }

    protected void doGetReplicationController(Exchange exchange, String operation) throws Exception {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Get a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Get a specific replication controller require specify a namespace name");
        }
        rc = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).get();
        exchange.getOut().setBody((Object)rc);
    }

    protected void doCreateReplicationController(Exchange exchange, String operation) throws Exception {
        ReplicationController rc = null;
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        ReplicationControllerSpec rcSpec = (ReplicationControllerSpec)exchange.getIn().getHeader("CamelKubernetesReplicationControllerSpec", ReplicationControllerSpec.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Create a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Create a specific replication controller require specify a namespace name");
        }
        if (ObjectHelper.isEmpty((Object)rcSpec)) {
            LOG.error("Create a specific replication controller require specify a replication controller spec bean");
            throw new IllegalArgumentException("Create a specific replication controller require specify a replication controller spec bean");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesReplicationControllersLabels", Map.class);
        EditableReplicationController rcCreating = ((ReplicationControllerBuilder)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder().withNewMetadata().withName(rcName)).withLabels(labels)).endMetadata()).withSpec(rcSpec)).build();
        rc = (ReplicationController)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).create((Object[])new ReplicationController[]{rcCreating});
        exchange.getOut().setBody((Object)rc);
    }

    protected void doDeleteReplicationController(Exchange exchange, String operation) throws Exception {
        String rcName = (String)exchange.getIn().getHeader("CamelKubernetesReplicationControllerName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)rcName)) {
            LOG.error("Delete a specific replication controller require specify a replication controller name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a replication controller name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific replication controller require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific replication controller require specify a namespace name");
        }
        boolean rcDeleted = (Boolean)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(namespaceName)).withName(rcName)).delete();
        exchange.getOut().setBody((Object)rcDeleted);
    }
}

