/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPersistentVolumesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPersistentVolumesProducer.class);

    public KubernetesPersistentVolumesProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listPersistentVolumes": {
                this.doList(exchange, operation);
                break;
            }
            case "listPersistentVolumesByLabels": {
                this.doListPersistentVolumesByLabels(exchange, operation);
                break;
            }
            case "getPersistentVolume": {
                this.doGetPersistentVolume(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        PersistentVolumeList persistentVolumeList = (PersistentVolumeList)((FilterWatchListMultiDeletable)this.getEndpoint().getKubernetesClient().persistentVolumes().inAnyNamespace()).list();
        exchange.getOut().setBody((Object)persistentVolumeList.getItems());
    }

    protected void doListPersistentVolumesByLabels(Exchange exchange, String operation) throws Exception {
        PersistentVolumeList pvList = null;
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesPersistentVolumesLabels", Map.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (!ObjectHelper.isEmpty((Object)namespaceName)) {
            ClientNonNamespaceOperation pvs = (ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumes().inNamespace(namespaceName);
            for (Map.Entry entry : labels.entrySet()) {
                pvs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            pvList = (PersistentVolumeList)pvs.list();
        } else {
            ClientMixedOperation pvs = this.getEndpoint().getKubernetesClient().persistentVolumes();
            for (Map.Entry entry : labels.entrySet()) {
                pvs.withLabel((String)entry.getKey(), (String)entry.getValue());
            }
            pvList = (PersistentVolumeList)pvs.list();
        }
        exchange.getOut().setBody((Object)pvList.getItems());
    }

    protected void doGetPersistentVolume(Exchange exchange, String operation) throws Exception {
        PersistentVolume pv = null;
        String pvName = (String)exchange.getIn().getHeader("CamelKubernetesPersistentVolumeName", String.class);
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)pvName)) {
            LOG.error("Get a specific Persistent Volume require specify a Persistent Volume name");
            throw new IllegalArgumentException("Get a specific Persistent Volume require specify a Persistent Volume name");
        }
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific Persistent Volume require specify a namespace name");
            throw new IllegalArgumentException("Get a specific Persistent Volume require specify a namespace name");
        }
        pv = (PersistentVolume)((ClientResource)((ClientNonNamespaceOperation)this.getEndpoint().getKubernetesClient().persistentVolumes().inNamespace(namespaceName)).withName(pvName)).get();
        exchange.getOut().setBody((Object)pv);
    }
}

