/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.producer;

import io.fabric8.kubernetes.api.model.EditableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesNamespacesProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesNamespacesProducer.class);

    public KubernetesNamespacesProducer(KubernetesEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.getEndpoint().getKubernetesConfiguration().getOperation()) ? (String)exchange.getIn().getHeader("CamelKubernetesOperation", String.class) : this.getEndpoint().getKubernetesConfiguration().getOperation();
        switch (operation) {
            case "listNamespaces": {
                this.doList(exchange, operation);
                break;
            }
            case "listNamespacesByLabels": {
                this.doListNamespaceByLabel(exchange, operation);
                break;
            }
            case "getNamespace": {
                this.doGetNamespace(exchange, operation);
                break;
            }
            case "createNamespace": {
                this.doCreateNamespace(exchange, operation);
                break;
            }
            case "deleteNamespace": {
                this.doDeleteNamespace(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doList(Exchange exchange, String operation) throws Exception {
        NamespaceList namespacesList = (NamespaceList)this.getEndpoint().getKubernetesClient().namespaces().list();
        exchange.getOut().setBody((Object)namespacesList.getItems());
    }

    protected void doListNamespaceByLabel(Exchange exchange, String operation) {
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNamespaceLabels", Map.class);
        if (ObjectHelper.isEmpty((Object)labels)) {
            LOG.error("Get a specific namespace by labels require specify a labels set");
            throw new IllegalArgumentException("Get a specific namespace by labels require specify a labels set");
        }
        ClientNonNamespaceOperation namespaces = this.getEndpoint().getKubernetesClient().namespaces();
        for (Map.Entry entry : labels.entrySet()) {
            namespaces.withLabel((String)entry.getKey(), (String)entry.getValue());
        }
        NamespaceList namespace = (NamespaceList)namespaces.list();
        exchange.getOut().setBody((Object)namespace.getItems());
    }

    protected void doGetNamespace(Exchange exchange, String operation) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Get a specific namespace require specify a namespace name");
            throw new IllegalArgumentException("Get a specific namespace require specify a namespace name");
        }
        Namespace namespace = (Namespace)((ClientResource)this.getEndpoint().getKubernetesClient().namespaces().withName(namespaceName)).get();
        exchange.getOut().setBody((Object)namespace);
    }

    protected void doCreateNamespace(Exchange exchange, String operation) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Create a specific namespace require specify a namespace name");
            throw new IllegalArgumentException("Create a specific namespace require specify a namespace name");
        }
        Map labels = (Map)exchange.getIn().getHeader("CamelKubernetesNamespaceLabels", Map.class);
        EditableNamespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespaceName)).withLabels(labels)).endMetadata()).build();
        Namespace namespace = (Namespace)this.getEndpoint().getKubernetesClient().namespaces().create((Object[])new Namespace[]{ns});
        exchange.getOut().setBody((Object)namespace);
    }

    protected void doDeleteNamespace(Exchange exchange, String operation) {
        String namespaceName = (String)exchange.getIn().getHeader("CamelKubernetesNamespaceName", String.class);
        if (ObjectHelper.isEmpty((Object)namespaceName)) {
            LOG.error("Delete a specific namespace require specify a namespace name");
            throw new IllegalArgumentException("Delete a specific namespace require specify a namespace name");
        }
        Boolean namespace = (Boolean)((ClientResource)this.getEndpoint().getKubernetesClient().namespaces().withName(namespaceName)).delete();
        exchange.getOut().setBody((Object)namespace);
    }
}

