/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.consumer;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.ServiceEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesServicesConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesServicesConsumer.class);
    private final Processor processor;
    private ExecutorService executor;

    public KubernetesServicesConsumer(KubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.executor.submit(new ServicesConsumerTask());
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Services Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ServicesConsumerTask
    implements Runnable {
        ServicesConsumerTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getOauthToken())) {
                if (ObjectHelper.isNotEmpty((Object)KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())) {
                    ((ClientNonNamespaceOperation)KubernetesServicesConsumer.this.getEndpoint().getKubernetesClient().services().inNamespace(KubernetesServicesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())).watch((Object)new Watcher<Service>(){

                        public void eventReceived(Watcher.Action action, Service resource) {
                            ServiceEvent se = new ServiceEvent(action, resource);
                            Exchange exchange = KubernetesServicesConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)se.getService());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesServicesConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesServicesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                } else {
                    KubernetesServicesConsumer.this.getEndpoint().getKubernetesClient().services().watch((Object)new Watcher<Service>(){

                        public void eventReceived(Watcher.Action action, Service resource) {
                            ServiceEvent se = new ServiceEvent(action, resource);
                            Exchange exchange = KubernetesServicesConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)se.getService());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesServicesConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesServicesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                }
            }
        }
    }
}

