/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.consumer;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.SecretEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSecretsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesSecretsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;

    public KubernetesSecretsConsumer(KubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.executor.submit(new SecretsConsumerTask());
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Secrets Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class SecretsConsumerTask
    implements Runnable {
        SecretsConsumerTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((Object)KubernetesSecretsConsumer.this.getEndpoint().getKubernetesConfiguration().getOauthToken())) {
                if (ObjectHelper.isNotEmpty((Object)KubernetesSecretsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())) {
                    ((ClientNonNamespaceOperation)KubernetesSecretsConsumer.this.getEndpoint().getKubernetesClient().secrets().inNamespace(KubernetesSecretsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())).watch((Object)new Watcher<Secret>(){

                        public void eventReceived(Watcher.Action action, Secret resource) {
                            SecretEvent se = new SecretEvent(action, resource);
                            Exchange exchange = KubernetesSecretsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)se.getSecret());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesSecretsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesSecretsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                } else {
                    KubernetesSecretsConsumer.this.getEndpoint().getKubernetesClient().secrets().watch((Object)new Watcher<Secret>(){

                        public void eventReceived(Watcher.Action action, Secret resource) {
                            SecretEvent se = new SecretEvent(action, resource);
                            Exchange exchange = KubernetesSecretsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)se.getSecret());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)se.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesSecretsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesSecretsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                }
            }
        }
    }
}

