/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.consumer;

import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.ReplicationControllerEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesReplicationControllersConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesReplicationControllersConsumer.class);
    private final Processor processor;
    private ExecutorService executor;

    public KubernetesReplicationControllersConsumer(KubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.executor.submit(new ReplicationControllersConsumerTask());
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Replication Controllers Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class ReplicationControllersConsumerTask
    implements Runnable {
        ReplicationControllersConsumerTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getOauthToken())) {
                if (ObjectHelper.isNotEmpty((Object)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())) {
                    ((ClientNonNamespaceOperation)KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers().inNamespace(KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())).watch((Object)new Watcher<ReplicationController>(){

                        public void eventReceived(Watcher.Action action, ReplicationController resource) {
                            ReplicationControllerEvent rce = new ReplicationControllerEvent(action, resource);
                            Exchange exchange = KubernetesReplicationControllersConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)rce.getReplicationController());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)rce.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                } else {
                    KubernetesReplicationControllersConsumer.this.getEndpoint().getKubernetesClient().replicationControllers().watch((Object)new Watcher<ReplicationController>(){

                        public void eventReceived(Watcher.Action action, ReplicationController resource) {
                            ReplicationControllerEvent se = new ReplicationControllerEvent(action, resource);
                            ReplicationControllerEvent rce = new ReplicationControllerEvent(action, resource);
                            Exchange exchange = KubernetesReplicationControllersConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)rce.getReplicationController());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)rce.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesReplicationControllersConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesReplicationControllersConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                }
            }
        }
    }
}

