/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.consumer;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.KubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.PodEvent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesPodsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesPodsConsumer.class);
    private final Processor processor;
    private ExecutorService executor;

    public KubernetesPodsConsumer(KubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public KubernetesEndpoint getEndpoint() {
        return (KubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.executor.submit(new PodsConsumerTask());
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Kubernetes Pods Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class PodsConsumerTask
    implements Runnable {
        PodsConsumerTask() {
        }

        @Override
        public void run() {
            if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getOauthToken())) {
                if (ObjectHelper.isNotEmpty((Object)KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())) {
                    ((ClientNonNamespaceOperation)KubernetesPodsConsumer.this.getEndpoint().getKubernetesClient().pods().inNamespace(KubernetesPodsConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespaceName())).watch((Object)new Watcher<Pod>(){

                        public void eventReceived(Watcher.Action action, Pod resource) {
                            PodEvent pe = new PodEvent(action, resource);
                            Exchange exchange = KubernetesPodsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)pe.getPod());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)pe.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesPodsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesPodsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                } else {
                    KubernetesPodsConsumer.this.getEndpoint().getKubernetesClient().pods().watch((Object)new Watcher<Pod>(){

                        public void eventReceived(Watcher.Action action, Pod resource) {
                            PodEvent pe = new PodEvent(action, resource);
                            Exchange exchange = KubernetesPodsConsumer.this.getEndpoint().createExchange();
                            exchange.getIn().setBody((Object)pe.getPod());
                            exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)pe.getAction());
                            exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                            try {
                                KubernetesPodsConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                KubernetesPodsConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                            }
                        }

                        public void onClose(KubernetesClientException cause) {
                            if (cause != null) {
                                LOG.error(cause.getMessage(), (Throwable)cause);
                            }
                        }
                    });
                }
            }
        }
    }
}

