/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.rabbitmq.RabbitMQEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQMessagePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQMessagePublisher.class);
    private final Exchange camelExchange;
    private final Channel channel;
    private final String routingKey;
    private final RabbitMQEndpoint endpoint;
    private final Message message;

    public RabbitMQMessagePublisher(Exchange camelExchange, Channel channel, String routingKey, RabbitMQEndpoint endpoint) {
        this.camelExchange = camelExchange;
        this.channel = channel;
        this.routingKey = routingKey;
        this.endpoint = endpoint;
        this.message = this.resolveMessageFrom(camelExchange);
    }

    private Message resolveMessageFrom(Exchange camelExchange) {
        Message message;
        Message message2 = message = camelExchange.hasOut() ? camelExchange.getOut() : camelExchange.getIn();
        if (message.getHeaders() != null && message.getHeaders().containsKey("CamelSerialize")) {
            LOG.debug("Removing the {} header", (Object)"CamelSerialize");
            message.getHeaders().remove("CamelSerialize");
        }
        return message;
    }

    public void publish() throws IOException {
        AMQP.BasicProperties properties;
        byte[] body;
        try {
            body = (byte[])this.camelExchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, this.camelExchange, this.message.getBody());
            properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
        }
        catch (NoTypeConversionAvailableException | TypeConversionException e) {
            if (this.message.getBody() instanceof Serializable) {
                this.message.getHeaders().put("CamelSerialize", true);
                properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
                body = this.serializeBodyFrom(this.message);
            }
            if (this.message.getBody() == null) {
                properties = this.endpoint.getMessageConverter().buildProperties(this.camelExchange).build();
                body = null;
            }
            LOG.warn("Could not convert {} to byte[]", this.message.getBody());
            throw new RuntimeCamelException(e);
        }
        this.publishToRabbitMQ(properties, body);
    }

    private void publishToRabbitMQ(AMQP.BasicProperties properties, byte[] body) throws IOException {
        String rabbitExchange = this.endpoint.getExchangeName(this.message);
        Boolean mandatory = (Boolean)this.camelExchange.getIn().getHeader("rabbitmq.MANDATORY", (Object)this.endpoint.isMandatory(), Boolean.class);
        Boolean immediate = (Boolean)this.camelExchange.getIn().getHeader("rabbitmq.IMMEDIATE", (Object)this.endpoint.isImmediate(), Boolean.class);
        LOG.debug("Sending message to exchange: {} with CorrelationId = {}", (Object)rabbitExchange, (Object)properties.getCorrelationId());
        if (this.endpoint.isPublisherAcknowledgements()) {
            this.channel.confirmSelect();
        }
        this.channel.basicPublish(rabbitExchange, this.routingKey, mandatory.booleanValue(), immediate.booleanValue(), properties, body);
        if (this.endpoint.isPublisherAcknowledgements()) {
            this.waitForConfirmation();
        }
    }

    private void waitForConfirmation() throws IOException {
        try {
            LOG.debug("Waiting for publisher acknowledgements for {}ms", (Object)this.endpoint.getPublisherAcknowledgementsTimeout());
            this.channel.waitForConfirmsOrDie(this.endpoint.getPublisherAcknowledgementsTimeout());
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.warn("Acknowledgement error for {}", (Object)this.camelExchange);
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] serializeBodyFrom(Message msg) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

